#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <string.h>
#include <windows.h>

typedef unsigned char byte;

void error (const char *s)
{
	printf ("Error: %s\nPress any key to quit", s);
	getch ();
	exit (1);
}

const unsigned int maxlen = 256;
typedef struct
{
	unsigned int pos;
	unsigned int len;
	byte data[maxlen];
}
part_t;

int match (byte *buffer, unsigned int length, const part_t *part)
{
	int i;
	for (i=0; part[i].len; i++)
	{
		if (length < part[i].pos + part[i].len)
			return false;
		if (memcmp (buffer + part[i].pos, part[i].data, part[i].len))
			return false;
	}
	return true;
}

int modify (byte *buffer, unsigned int length, const part_t *part)
{
	int i;
	for (i=0; part[i].len; i++)
	{
		if (length < part[i].pos + part[i].len)
			return false;
		memcpy (buffer + part[i].pos, part[i].data, part[i].len);
	}
	return true;
}

int main (int argc, char **argv)
{
	const part_t part_35_normal[] =
	{
		{0x277A2, 2, {0x8B, 0x57}}, // dont know the exact meaning
		{0x277D3, 2, {0x75, 0xCD}}, // the loop in the converting
		{0xD42A0, 102, "( %.0f %.0f %.0f ) ( %.0f %.0f %.0f ) ( %.0f %.0f %.0f ) %s [ %g %g %g %g ] [ %g %g %g %g ] %g %g %g "},
		{0xD4308, 110, "( %.0f %.0f %.0f ) ( %.0f %.0f %.0f ) ( %.0f %.0f %.0f ) %s [ %g %g %g %g ] [ %g %g %g %g ] %g %g %g %u %u %u"},
		{0,0}
	};
	const part_t part_35_fp[] =
	{
		{0x277A2, 2, {0x75, 0x31}}, // skip converting the plane points to integers
		{0x277D3, 2, {0x75, 0xCD}}, // the loop in the converting
		{0xD42A0, 102, "( %.8f %.8f %.8f ) ( %.8f %.8f %.8f ) ( %.8f %.8f %.8f ) %s [ %g %g %g %g ] [ %g %g %g %g ] %g %g %g "},
		{0xD4308, 110, "( %.8f %.8f %.8f ) ( %.8f %.8f %.8f ) ( %.8f %.8f %.8f ) %s [ %g %g %g %g ] [ %g %g %g %g ] %g %g %g %u %u %u"},
		{0,0}
	};
	const part_t part_35_unknown[] = 
	{
		{0x277D3, 2, {0x75, 0xCD}}, // the loop in the converting
		{0xD4480, 15,"220\0mapversion\0"},
		{0,0}
	};
	const part_t part_34_normal[] =
	{
		{0x27442, 2, {0x8B, 0x57}}, // dont know the exact meaning
		{0x27473, 2, {0x75, 0xCD}}, // the loop in the converting
		{0xD3290, 102, "( %.0f %.0f %.0f ) ( %.0f %.0f %.0f ) ( %.0f %.0f %.0f ) %s [ %g %g %g %g ] [ %g %g %g %g ] %g %g %g "},
		{0xD32F8, 110, "( %.0f %.0f %.0f ) ( %.0f %.0f %.0f ) ( %.0f %.0f %.0f ) %s [ %g %g %g %g ] [ %g %g %g %g ] %g %g %g %u %u %u"},
		{0,0}
	};
	const part_t part_34_fp[] =
	{
		{0x27442, 2, {0x75, 0x31}}, // skip converting the plane points to integers
		{0x27473, 2, {0x75, 0xCD}}, // the loop in the converting
		{0xD3290, 102, "( %.8f %.8f %.8f ) ( %.8f %.8f %.8f ) ( %.8f %.8f %.8f ) %s [ %g %g %g %g ] [ %g %g %g %g ] %g %g %g "},
		{0xD32F8, 110, "( %.8f %.8f %.8f ) ( %.8f %.8f %.8f ) ( %.8f %.8f %.8f ) %s [ %g %g %g %g ] [ %g %g %g %g ] %g %g %g %u %u %u"},
		{0,0}
	};
	const part_t part_34_unknown[] =
	{
		{0x27473, 2, {0x75, 0xCD}}, // the loop in the converting
		{0xD3470, 15,"220\0mapversion\0"},
		{0,0}
	};
	printf ("Hammer floating point enabler\n    by vluzacn(email:vluzacn@163.com)\n");
	char filename[MAX_PATH+1];
	if (argc > 1)
	{
		strncpy (filename, argv[1], MAX_PATH);
	}
	else
	{
		printf ("Path of hammer.exe:\n");
		OPENFILENAME ofn;
		memset (&ofn, 0, sizeof(ofn));
		ofn.lStructSize = sizeof(ofn);
		ofn.lpstrFile = filename;
		strcpy (filename, "");
		ofn.nMaxFile = MAX_PATH;
		ofn.lpstrDefExt = "exe";
		ofn.lpstrFilter = "Executable(hammer.exe)\0*.exe\0All Files(*.*)\0*.*\0";
		ofn.nFilterIndex = 1;
		ofn.Flags = OFN_EXPLORER | OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT | OFN_FILEMUSTEXIST;
		ofn.lpstrTitle = "Convert Valve Hammer Editor Executable";
		if (!GetSaveFileName (&ofn))
			error ("No file selected");
		printf ("%s\n", filename);
	}
	const part_t *type;
	unsigned int length;
	byte *buffer;
	{
		FILE *f;
		if (!(f = fopen (filename, "rb")))
			error ("Can not open file for read");
	    fseek(f, 0, SEEK_END);
		length = ftell (f);
	    fseek(f, 0, SEEK_SET);
		if (!(buffer = (byte *)malloc (length)))
			error ("No memory");
		if (fread (buffer, 1, length, f) != length)
			error ("Can not read file");
		if (match (buffer, length, part_35_normal))
		{
			type = part_35_normal;
			printf ("Detected version: Valve Hammer Editor 3.5 (normal)\n");
		}
		else if (match (buffer, length, part_35_fp))
		{
			type = part_35_fp;
			printf ("Detected version: Valve Hammer Editor 3.5 (already modified)\n");
		}
		else if (match (buffer, length, part_35_unknown))
		{
			type = part_35_unknown;
			printf ("Detected version: Valve Hammer Editor 3.5 (other)\n");
		}
		else if (match (buffer, length, part_34_normal))
		{
			type = part_34_normal;
			printf ("Detected version: Valve Hammer Editor 3.4 (normal)\n");
		}
		else if (match (buffer, length, part_34_fp))
		{
			type = part_34_fp;
			printf ("Detected version: Valve Hammer Editor 3.4 (already modified)\n");
		}
		else if (match (buffer, length, part_34_unknown))
		{
			type = part_34_unknown;
			printf ("Detected version: Valve Hammer Editor 3.5 (other)\n");
		}
		else
		{
			error ("Not hammer.exe from Valve Hammer Editor 3.4 or 3.5");
		}
		fclose (f);
	}
	{
		printf ("Press 1 to convert to normal version\nPress 2 to enable floating point coordinates output\n");
		int key = getch ();
		if (key == '1')
		{
			if (type == part_35_normal || type == part_35_fp || type == part_35_unknown)
				type = part_35_normal;
			if (type == part_34_normal || type == part_34_fp || type == part_34_unknown)
				type = part_34_normal;
		}
		else if (key == '2')
		{
			if (type == part_35_normal || type == part_35_fp || type == part_35_unknown)
				type = part_35_fp;
			if (type == part_34_normal || type == part_34_fp || type == part_34_unknown)
				type = part_34_fp;
		}
		else
			error ("Invalid input");
	}
	{
		FILE *f;
		if (!(f = fopen (filename, "wb")))
			error ("Can not open file for write");
		modify (buffer, length, type);
		if (fwrite (buffer, 1, length, f) != length)
			error ("Can not write file");
		free (buffer);
		fclose (f);
	}
	printf ("Done\nPress any key to quit");
	getch ();
	return 0;
}
