#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <string.h>
#include <windows.h>

typedef unsigned char byte;

void error (const char *s)
{
	printf ("Error: %s\nPress any key to quit", s);
	getch ();
	exit (1);
}

const unsigned int maxlen = 256;
typedef struct
{
	unsigned int pos;
	unsigned int len;
	byte data[maxlen];
}
part_t;

int match (byte *buffer, unsigned int length, const part_t *part)
{
	int i;
	for (i=0; part[i].len; i++)
	{
		if (length < part[i].pos + part[i].len)
			return false;
		if (memcmp (buffer + part[i].pos, part[i].data, part[i].len))
			return false;
	}
	return true;
}

int modify (byte *buffer, unsigned int length, const part_t *part)
{
	int i;
	for (i=0; part[i].len; i++)
	{
		if (length < part[i].pos + part[i].len)
			return false;
		memcpy (buffer + part[i].pos, part[i].data, part[i].len);
	}
	return true;
}

int main (int argc, char **argv)
{
	const part_t part_35_4096[] =
	{
		{0x215F9, 4, {0x00,0x00,0x80,0x45}}, // max (float)4096
		{0x21603, 4, {0x00,0x00,0x80,0xC5}}, // min (float)-4096
		{0x51CD9, 4, {0x10,0x27,0x00,0x00}}, // visibility (int)10000
		{0x3C4F1, 4, {0x00,0x00,0x00,0x3D}}, // min scale to reach (float)0.03125
		{0x3C514, 4, {0x00,0x00,0x80,0x43}}, // max scale to reach (float)256
		{0xB96E8, 8, {0x00,0x00,0x00,0x00,0x00,0x00,0x70,0x40}}, // max scale (double)256
		{0xB96F0, 8, {0x00,0x00,0x00,0x00,0x00,0x00,0xA0,0x3F}}, // min scale (double)0.03125
		{0,0}
	};
	const part_t part_35_16384[] =
	{
		{0x215F9, 4, {0x00,0x00,0x80,0x46}}, // max (float)16384
		{0x21603, 4, {0x00,0x00,0x80,0xC6}}, // min (float)-16384
		{0x51CD9, 4, {0x20,0x4E,0x00,0x00}}, // visibility (int)20000
		{0x3C4F1, 4, {0x00,0x00,0x80,0x3C}}, // min scale to reach (float)0.015625
		{0x3C514, 4, {0x00,0x00,0x00,0x43}}, // max scale to reach (float)128
		{0xB96E8, 8, {0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x40}}, // max scale (double)128
		{0xB96F0, 8, {0x00,0x00,0x00,0x00,0x00,0x00,0x90,0x3F}}, // min scale (double)0.015625
		{0,0}
	};
	const part_t part_35_unknown[] = 
	{
		{0xD4480, 16,"220\0mapversion\0"},
		{0,0}
	};
	const part_t part_34_4096[] =
	{
		{0x212C9, 4, {0x00,0x00,0x80,0x45}}, // max (float)4096
		{0x212D3, 4, {0x00,0x00,0x80,0xC5}}, // min (float)-4096
		{0x51959, 4, {0x10,0x27,0x00,0x00}}, // visibility (int)10000
		{0x3C231, 4, {0x00,0x00,0x00,0x3D}}, // min scale to reach (float)0.03125
		{0x3C254, 4, {0x00,0x00,0x80,0x43}}, // max scale to reach (float)256
		{0xB86E0, 8, {0x00,0x00,0x00,0x00,0x00,0x00,0x70,0x40}}, // max scale (double)256
		{0xB86E8, 8, {0x00,0x00,0x00,0x00,0x00,0x00,0xA0,0x3F}}, // min scale (double)0.03125
		{0,0}
	};
	const part_t part_34_16384[] =
	{
		{0x212C9, 4, {0x00,0x00,0x80,0x46}}, // max (float)16384
		{0x212D3, 4, {0x00,0x00,0x80,0xC6}}, // min (float)-16384
		{0x51959, 4, {0x20,0x4E,0x00,0x00}}, // visibility (int)20000
		{0x3C231, 4, {0x00,0x00,0x80,0x3C}}, // min scale to reach (float)0.015625
		{0x3C254, 4, {0x00,0x00,0x00,0x43}}, // max scale to reach (float)128
		{0xB86E0, 8, {0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x40}}, // max scale (double)128
		{0xB86E8, 8, {0x00,0x00,0x00,0x00,0x00,0x00,0x90,0x3F}}, // min scale (double)0.015625
		{0,0}
	};
	const part_t part_34_unknown[] =
	{
		{0xD3470, 16,"220\0mapversion\0"},
		{0,0}
	};
	char filename[MAX_PATH+1];
	if (argc > 1)
	{
		strncpy (filename, argv[1], MAX_PATH);
	}
	else
	{
		OPENFILENAME ofn;
		memset (&ofn, 0, sizeof(ofn));
		ofn.lStructSize = sizeof(ofn);
		ofn.lpstrFile = filename;
		strcpy (filename, "");
		ofn.nMaxFile = MAX_PATH;
		ofn.lpstrDefExt = "exe";
		ofn.lpstrFilter = "Executable(hammer.exe)\0*.exe\0All Files(*.*)\0*.*\0";
		ofn.nFilterIndex = 1;
		ofn.Flags = OFN_EXPLORER | OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT | OFN_FILEMUSTEXIST;
		ofn.lpstrTitle = "Convert Valve Hammer Editor Executable";
		if (!GetSaveFileName (&ofn))
			error ("No file selected");
		printf ("%s\n", filename);
	}
	const part_t *type;
	unsigned int length;
	byte *buffer;
	{
		FILE *f;
		if (!(f = fopen (filename, "rb")))
			error ("Can not open file for read");
	    fseek(f, 0, SEEK_END);
		length = ftell (f);
	    fseek(f, 0, SEEK_SET);
		if (!(buffer = (byte *)malloc (length)))
			error ("No memory");
		if (fread (buffer, 1, length, f) != length)
			error ("Can not read file");
		if (match (buffer, length, part_35_4096))
		{
			type = part_35_4096;
			printf ("Detected version: Valve Hammer Editor 3.5 (normal)\n");
		}
		else if (match (buffer, length, part_35_16384))
		{
			type = part_35_16384;
			printf ("Detected version: Valve Hammer Editor 3.5 (already modified)\n");
		}
		else if (match (buffer, length, part_35_unknown))
		{
			type = part_35_unknown;
			printf ("Detected version: Valve Hammer Editor 3.5 (other)\n");
		}
		else if (match (buffer, length, part_34_4096))
		{
			type = part_34_4096;
			printf ("Detected version: Valve Hammer Editor 3.4 (normal)\n");
		}
		else if (match (buffer, length, part_34_16384))
		{
			type = part_34_16384;
			printf ("Detected version: Valve Hammer Editor 3.4 (already modified)\n");
		}
		else if (match (buffer, length, part_34_unknown))
		{
			type = part_34_unknown;
			printf ("Detected version: Valve Hammer Editor 3.5 (other)\n");
		}
		else
		{
			error ("Not hammer.exe from Valve Hammer Editor 3.4 or 3.5");
		}
		fclose (f);
	}
	{
		printf ("Press 1 to convert to normal version\nPress 2 to enlarge the range of grid\n");
		int key = getch ();
		if (key == '1')
		{
			if (type == part_35_4096 || type == part_35_16384 || type == part_35_unknown)
				type = part_35_4096;
			if (type == part_34_4096 || type == part_34_16384 || type == part_34_unknown)
				type = part_34_4096;
		}
		else if (key == '2')
		{
			if (type == part_35_4096 || type == part_35_16384 || type == part_35_unknown)
				type = part_35_16384;
			if (type == part_34_4096 || type == part_34_16384 || type == part_34_unknown)
				type = part_34_16384;
		}
		else
			error ("Invalid input");
	}
	{
		FILE *f;
		if (!(f = fopen (filename, "wb")))
			error ("Can not open file for write");
		modify (buffer, length, type);
		if (fwrite (buffer, 1, length, f) != length)
			error ("Can not write file");
		free (buffer);
		fclose (f);
	}
	printf ("Done\nPress any key to quit");
	getch ();
	return 0;
}