uniform sampler2D tex0, tex1, tex2, tex3;
// distribution tex, then tex1-3

uniform sampler2D shadowTex;
varying vec4 shadowVec;

varying vec3 normal;
varying vec3 vert;
varying float light;

void main()
{
	vec4 dist = texture2D(tex0, gl_TexCoord[0].st);
	vec4 map1 = texture2D(tex1, gl_TexCoord[1].st);
	vec4 map2 = texture2D(tex2, gl_TexCoord[2].st);
	vec4 map3 = texture2D(tex3, gl_TexCoord[3].st);

	vec4 shadowMath = shadowVec / shadowVec.w;
	shadowMath.z -= 0.0005;
	
	float shadowDist;
	
	float shadow = 1.0;
	if (shadowVec.w > 0.0)
	{
		vec2 coord = shadowMath.st;
		float x, y;
		for (y = -0.0005; y <= 0.0005; y += 0.0005)
			for (x = -0.0005; x <= 0.0005; x += 0.0005)
			{
				shadowDist = texture2D(shadowTex, shadowMath.st + vec2(x, y));
				shadow += shadowDist < shadowMath.z ? 0.6 : 1.0;
			}
		
		shadow /= 9.0;

		//shadowDist = texture2D(shadowTex, shadowMath.st).z;
		//shadow = shadowDist < shadowMath.z ? 0.5 : 1.0;		
	}

	gl_FragColor.rgb = (map1.rgb * dist.r + map2.rgb * dist.g + map3.rgb * dist.b)*shadow;
	gl_FragColor.a = 1.0 - max((gl_FragCoord.z / gl_FragCoord.w) - 14000.0, 0.0) / 2384.0;
	gl_FragColor = gl_FragColor * gl_Color.rgba;
}