uniform sampler2D tex0, tex1, tex2, tex3;
// distribution tex, then tex1-3

varying vec3 normal;
varying vec3 lightDiff;
varying vec3 vert;
varying float light;

void main()
{
	vec4 dist = texture2D(tex0, gl_TexCoord[0].st);
	vec4 map1 = texture2D(tex1, gl_TexCoord[1].st);
	vec4 map2 = texture2D(tex2, gl_TexCoord[2].st);
	vec4 map3 = texture2D(tex3, gl_TexCoord[3].st);

	gl_FragColor.rgb = (map1.rgb * dist.r + map2.rgb * dist.g + map3.rgb * dist.b);
	gl_FragColor.a = 1.0 - max((gl_FragCoord.z / gl_FragCoord.w) - 14000.0, 0.0) / 2384.0;
	gl_FragColor = gl_FragColor * gl_Color.rgba;
}