/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bspinfo.gui.models;

import info.ata4.bsplib.BspFile;
import info.ata4.bsplib.lump.GameLump;
import info.ata4.util.gui.ListTableModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class GameLumpTableModel
extends ListTableModel {
    public GameLumpTableModel() {
        super(4);
        this.columnNames = Arrays.asList("Name", "Size", "Size usage", "Version");
        this.columnClasses = new Class[]{String.class, Integer.class, Integer.class, Integer.class};
    }

    public GameLumpTableModel(BspFile bspFile) {
        this();
        List<GameLump> lumps = bspFile.getGameLumps();
        float lumpSize = 0.0f;
        for (GameLump l : lumps) {
            lumpSize += (float)l.getLength();
        }
        for (GameLump l : lumps) {
            ArrayList<Object> row = new ArrayList<Object>();
            row.add(l.getName());
            row.add(l.getLength());
            row.add(Math.round((float)l.getLength() / lumpSize * 100.0f));
            row.add(l.getVersion());
            this.addRow(row);
        }
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }
}

