/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bsplib;

import info.ata4.bsplib.BspFile;
import info.ata4.bsplib.lump.Lump;
import info.ata4.bsplib.lump.LumpType;
import info.ata4.bspsrc.modules.texture.TextureSource;
import info.ata4.log.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;

public class PakFile {
    private static final Logger L = LogUtils.getLogger();
    private static Pattern vhvPattern = Pattern.compile("sp(_hdr)?_\\d+\\.vhv");
    private static Pattern cubemapVtfPattern = Pattern.compile("c(-?\\d+)_(-?\\d+)_(-?\\d+)(\\.hdr)?\\.vtf");
    private final Lump pakLump;

    public PakFile(BspFile bspFile) {
        this.pakLump = bspFile.getLump(LumpType.LUMP_PAKFILE);
    }

    public ZipArchiveInputStream getArchiveInputStream() {
        return new ZipArchiveInputStream(this.pakLump.getInputStream(), "Cp437", false);
    }

    public void unpack(Path dest) throws IOException {
        this.unpack(dest, false);
    }

    public void unpack(Path dest, boolean direct) throws IOException {
        if (direct) {
            L.log(Level.INFO, "Extracting pakfile to {0}", dest);
            try (InputStream is = this.pakLump.getInputStream();){
                Files.copy(is, dest, new CopyOption[0]);
            }
        } else {
            this.unpack(dest, s -> true);
        }
    }

    public void unpack(Path dest, Predicate<Path> nameFilter) throws IOException {
        Files.createDirectories(dest, new FileAttribute[0]);
        try (ZipArchiveInputStream zis = this.getArchiveInputStream();){
            ZipArchiveEntry ze;
            while ((ze = zis.getNextZipEntry()) != null) {
                Path zipPath;
                try {
                    zipPath = Paths.get(ze.getName(), new String[0]);
                }
                catch (InvalidPathException e) {
                    L.log(Level.WARNING, "Couldn't resolve ZipArchiveEntry path", e);
                    continue;
                }
                if (!nameFilter.test(zipPath)) continue;
                Path entryFile = dest.resolve(zipPath).normalize();
                if (!entryFile.startsWith(dest)) {
                    L.log(Level.WARNING, "Skipped {0} (path traversal attempt)", ze.getName());
                    continue;
                }
                if (Files.notExists(entryFile.getParent(), new LinkOption[0])) {
                    Files.createDirectories(entryFile.getParent(), new FileAttribute[0]);
                }
                if (Files.exists(entryFile, new LinkOption[0])) {
                    L.log(Level.WARNING, "Skipped {0} (exists)", ze.getName());
                    continue;
                }
                L.log(Level.INFO, "Extracting {0}", ze.getName());
                Files.copy(zis, entryFile, new CopyOption[0]);
            }
        }
    }

    public static Predicate<Path> nameFilter(Collection<String> names) {
        List paths = names.stream().flatMap(s -> {
            try {
                return Stream.of(Paths.get(s, new String[0]));
            }
            catch (InvalidPathException e) {
                L.log(Level.WARNING, "Error converting string to path", e);
                return Stream.empty();
            }
        }).collect(Collectors.toList());
        return paths::contains;
    }

    public static Predicate<Path> isVBSPGeneratedFile(String bspFileName) {
        return TextureSource.isPatchedMaterial(bspFileName).or(path -> {
            String fileName = path.getFileName().toString();
            return vhvPattern.matcher(fileName).matches() || cubemapVtfPattern.matcher(fileName).matches() || fileName.equalsIgnoreCase("cubemapdefault.vtf") || fileName.equalsIgnoreCase("cubemapdefault.hdr.vtf");
        });
    }
}

