/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bsplib.app;

import info.ata4.bsplib.app.SourceApp;
import info.ata4.log.LogUtils;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.io.LineIterator;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SourceAppHandler
extends DefaultHandler {
    private static final Logger L = LogUtils.getLogger();
    private List<SourceApp> appList = new ArrayList<SourceApp>();
    private SourceApp currentApp;
    private String currentElement;
    private StringBuilder entitiesBuf = new StringBuilder(4096);

    @Override
    public void startDocument() throws SAXException {
        this.appList.clear();
        this.currentApp = null;
        this.currentElement = null;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.currentElement = qName;
        if (qName.equals("app")) {
            String name = attributes.getValue("name");
            String id = attributes.getValue("id");
            if (name == null) {
                L.warning("Ignoring app with missing attribute \"name\"");
            } else if (id == null) {
                L.warning("Ignoring app with missing attribute \"id\"");
            } else {
                this.currentApp = new SourceApp(name, Integer.valueOf(id));
            }
        }
        if (this.currentApp == null) {
            return;
        }
        switch (qName) {
            case "version": {
                String minVers = attributes.getValue("min");
                String maxVers = attributes.getValue("max");
                if (minVers != null) {
                    this.currentApp.setVersionMin(Integer.valueOf(minVers));
                }
                if (maxVers == null) break;
                this.currentApp.setVersionMax(Integer.valueOf(maxVers));
                break;
            }
            case "entities": {
                String pointsEntities = attributes.getValue("points");
                if (pointsEntities == null) break;
                this.currentApp.setPointsEntities(Float.valueOf(pointsEntities).floatValue());
                break;
            }
            case "files": {
                String pointsFiles = attributes.getValue("points");
                if (pointsFiles == null) break;
                this.currentApp.setPointsFilePattern(Float.valueOf(pointsFiles).floatValue());
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals("app")) {
            this.appList.add(this.currentApp);
            this.currentApp = null;
        }
        if (this.currentApp == null) {
            return;
        }
        if (qName.equals("entities")) {
            LineIterator it = new LineIterator(new StringReader(this.entitiesBuf.toString()));
            while (it.hasNext()) {
                String entity = it.next().trim();
                if (entity.isEmpty()) continue;
                this.currentApp.getEntities().add(entity);
            }
            this.entitiesBuf.setLength(0);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.currentApp == null) {
            return;
        }
        switch (this.currentElement) {
            case "entities": {
                this.entitiesBuf.append(ch, start, length);
                break;
            }
            case "files": {
                String content = new String(ch, start, length);
                if (content.trim().isEmpty()) break;
                this.currentApp.setFilePattern(content);
            }
        }
    }

    public List<SourceApp> getAppList() {
        return Collections.unmodifiableList(this.appList);
    }
}

