/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bsplib.struct;

import info.ata4.bsplib.struct.DStaticProp;
import info.ata4.bsplib.struct.StaticPropFlag;
import info.ata4.bsplib.vector.Vector3f;
import info.ata4.io.DataReader;
import info.ata4.io.DataWriter;
import info.ata4.util.EnumConverter;
import java.io.IOException;
import java.util.Set;

public class DStaticPropV4
implements DStaticProp {
    public Vector3f origin;
    public Vector3f angles;
    public int propType;
    public int firstLeaf;
    public int leafCount;
    public int solid;
    public Set<StaticPropFlag> flags;
    public int skin;
    public float fademin;
    public float fademax;
    public Vector3f lightingOrigin;

    @Override
    public int getSize() {
        return 56;
    }

    @Override
    public void read(DataReader in) throws IOException {
        this.origin = Vector3f.read(in);
        this.angles = Vector3f.read(in);
        this.propType = in.readUnsignedShort();
        this.firstLeaf = in.readUnsignedShort();
        this.leafCount = in.readUnsignedShort();
        this.solid = in.readUnsignedByte();
        this.flags = EnumConverter.fromInteger(StaticPropFlag.class, in.readUnsignedByte());
        this.skin = in.readInt();
        this.fademin = in.readFloat();
        this.fademax = in.readFloat();
        this.lightingOrigin = Vector3f.read(in);
    }

    @Override
    public void write(DataWriter out) throws IOException {
        Vector3f.write(out, this.origin);
        Vector3f.write(out, this.angles);
        out.writeUnsignedShort(this.propType);
        out.writeUnsignedShort(this.firstLeaf);
        out.writeUnsignedShort(this.leafCount);
        out.writeUnsignedByte(this.solid);
        out.writeUnsignedByte(EnumConverter.toInteger(this.flags));
        out.writeInt(this.skin);
        out.writeFloat(this.fademin);
        out.writeFloat(this.fademax);
        Vector3f.write(out, this.lightingOrigin);
    }

    public boolean usesLightingOrigin() {
        return this.flags.contains((Object)StaticPropFlag.STATIC_PROP_USE_LIGHTING_ORIGIN);
    }

    public boolean hasNoShadowing() {
        return this.flags.contains((Object)StaticPropFlag.STATIC_PROP_NO_SHADOW);
    }

    public boolean hasNoSelfShadowing() {
        return this.flags.contains((Object)StaticPropFlag.STATIC_PROP_NO_SELF_SHADOWING);
    }

    public boolean hasNoPerVertexLighting() {
        return this.flags.contains((Object)StaticPropFlag.STATIC_PROP_NO_PER_VERTEX_LIGHTING);
    }

    public boolean hasNoPerTexelLighting() {
        return this.flags.contains((Object)StaticPropFlag.STATIC_PROP_NO_PER_TEXEL_LIGHTING);
    }

    public boolean hasIgnoreNormals() {
        return this.flags.contains((Object)StaticPropFlag.STATIC_PROP_IGNORE_NORMALS);
    }

    public boolean hasScreenSpaceFadeInPixels() {
        return this.flags.contains((Object)StaticPropFlag.STATIC_PROP_SCREEN_SPACE_FADE);
    }
}

