/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bsplib.util;

import info.ata4.bsplib.struct.BspData;
import info.ata4.bsplib.struct.DAreaportal;
import info.ata4.bsplib.struct.DBrush;
import info.ata4.bsplib.struct.DBrushSide;
import info.ata4.bsplib.struct.DOccluderPolyData;
import info.ata4.bsplib.struct.DPlane;
import info.ata4.bsplib.vector.Vector2f;
import info.ata4.bsplib.vector.Vector3f;
import info.ata4.bspsrc.util.Winding;
import info.ata4.bspsrc.util.WindingFactory;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class VectorUtil {
    public static double matchingAreaPercentage(DOccluderPolyData occluderPolyData, DBrush brush, DBrushSide brushSide, BspData bsp) {
        DPlane brushSidePlane;
        DPlane occluderPlane = bsp.planes.get(occluderPolyData.planenum);
        if (VectorUtil.shareSamePlane(occluderPlane, brushSidePlane = bsp.planes.get(brushSide.pnum))) {
            return VectorUtil.internalMatchingAreaPercentage(WindingFactory.fromOccluder(bsp, occluderPolyData), WindingFactory.fromSide(bsp, brush, brushSide));
        }
        return 0.0;
    }

    public static double matchingAreaPercentage(DAreaportal areaportal, DBrush brush, DBrushSide brushSide, BspData bsp) {
        DPlane brushSidePlane;
        DPlane areaportalPlane = bsp.planes.get(areaportal.planenum);
        if (VectorUtil.shareSamePlane(areaportalPlane, brushSidePlane = bsp.planes.get(brushSide.pnum))) {
            return VectorUtil.internalMatchingAreaPercentage(WindingFactory.fromAreaportal(bsp, areaportal), WindingFactory.fromSide(bsp, brush, brushSide));
        }
        return 0.0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean shareSamePlane(DPlane p1, DPlane p2) {
        if (!((double)p1.normal.normalize().cross(p2.normal.normalize()).length() < 0.001)) return false;
        float f = p1.dist;
        float f2 = p2.dist;
        int n = p1.normal.dot(p2.normal) >= 1.0f ? 1 : -1;
        if (!(Math.abs(f - f2 * (float)n) < 0.1f)) return false;
        return true;
    }

    private static double internalMatchingAreaPercentage(Winding w1, Winding w2) {
        Vector3f[] plane = w1.buildPlane();
        Vector3f vec1 = plane[1].sub(plane[0]);
        Vector3f vec2 = plane[2].sub(plane[0]);
        Vector3f planeNormal = vec2.cross(vec1).normalize();
        Vector3f origin = w1.get(0);
        Vector3f axis1 = w1.get(1).sub(origin).normalize();
        Vector3f axis2 = axis1.cross(planeNormal).normalize();
        List<Vector2f> w1Polygon = w1.stream().map(vertex -> vertex.getAsPointOnPlane(origin, axis1, axis2)).collect(Collectors.toList());
        List<Vector2f> w2Polygon = w2.stream().map(vertex -> vertex.getAsPointOnPlane(origin, axis1, axis2)).collect(Collectors.toList());
        HashSet<Vector2f> intersectingVertices = new HashSet<Vector2f>();
        intersectingVertices.addAll(w1Polygon.stream().filter(vertex -> VectorUtil.isInsideConvexPolygon(vertex, w2Polygon)).collect(Collectors.toList()));
        intersectingVertices.addAll(w2Polygon.stream().filter(vertex -> VectorUtil.isInsideConvexPolygon(vertex, w1Polygon)).collect(Collectors.toList()));
        intersectingVertices.addAll(VectorUtil.getPolygonIntersections(w1Polygon, w2Polygon));
        List<Vector2f> intersectionPolygon = VectorUtil.orderVertices(intersectingVertices);
        double intersectionArea = VectorUtil.polygonArea(intersectionPolygon);
        double w1Area = VectorUtil.polygonArea(w1Polygon);
        return intersectionArea / w1Area > 1.0 ? 0.0 : Math.abs(intersectionArea / w1Area);
    }

    public static boolean isInsideConvexPolygon(Vector2f p, List<Vector2f> polygon) {
        return IntStream.range(0, polygon.size()).mapToObj(i -> new Vector2f[]{(Vector2f)polygon.get(i), (Vector2f)polygon.get((i + 1) % polygon.size())}).filter(edge -> edge[0].y > p.y != edge[1].y > p.y && p.x < (edge[1].x - edge[0].x) * (p.y - edge[0].y) / (edge[1].y - edge[0].y) + edge[0].x).limit(2L).count() % 2L == 1L;
    }

    public static Set<Vector2f> getPolygonIntersections(List<Vector2f> polygon1, List<Vector2f> polygon2) {
        return IntStream.range(0, polygon1.size()).mapToObj(i -> new Vector2f[]{(Vector2f)polygon1.get(i), (Vector2f)polygon1.get((i + 1) % polygon1.size())}).flatMap(edge -> IntStream.range(0, polygon2.size()).mapToObj(i -> new Vector2f[]{(Vector2f)polygon2.get(i), (Vector2f)polygon2.get((i + 1) % polygon2.size())}).map(edge2 -> VectorUtil.lineIntersection(edge[0], edge[1], edge2[0], edge2[1]))).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
    }

    public static Optional<Vector2f> lineIntersection(Vector2f origin1, Vector2f end1, Vector2f origin2, Vector2f end2) {
        Vector2f cmP = origin2.sub(origin1);
        Vector2f r = end1.sub(origin1);
        Vector2f s = end2.sub(origin2);
        float CmPxr = cmP.x * r.y - cmP.y * r.x;
        float CmPxs = cmP.x * s.y - cmP.y * s.x;
        float rxs = r.x * s.y - r.y * s.x;
        if (rxs == 0.0f) {
            return Optional.empty();
        }
        float rxsr = 1.0f / rxs;
        float t = CmPxs * rxsr;
        float u = CmPxr * rxsr;
        if (t >= 0.0f && t <= 1.0f && u >= 0.0f && u <= 1.0f) {
            return Optional.of(origin1.add(end1.sub(origin1).scalar(t)));
        }
        return Optional.empty();
    }

    public static double polygonArea(List<Vector2f> polygon) {
        return IntStream.range(0, polygon.size()).mapToObj(i -> new Vector2f[]{(Vector2f)polygon.get(i), (Vector2f)polygon.get((i + 1) % polygon.size())}).mapToDouble(edge -> (edge[0].x + edge[1].x) * (edge[0].y - edge[1].y)).sum() / 2.0;
    }

    public static List<Vector2f> orderVertices(Collection<Vector2f> vertices) {
        Vector2f midPoint = vertices.stream().reduce((vertex1, vertex2) -> vertex1.add((Vector2f)vertex2).scalar(0.5f)).orElse(new Vector2f(0.0f, 0.0f));
        return vertices.stream().sorted(Comparator.comparingDouble(vertex -> Math.atan2(vertex.x - midPoint.x, vertex.y - midPoint.y))).collect(Collectors.toList());
    }
}

