/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bsplib.vector;

import info.ata4.bsplib.vector.VectorXf;
import info.ata4.io.DataReader;
import info.ata4.io.DataWriter;
import java.io.IOException;

public class Vector2f
extends VectorXf {
    public static final Vector2f NULL = new Vector2f(0.0f, 0.0f);
    public static final Vector2f MAX_VALUE = new Vector2f(Float.MAX_VALUE, Float.MAX_VALUE);
    public static final Vector2f MIN_VALUE = MAX_VALUE.scalar(-1.0f);
    public final float x;
    public final float y;

    public static Vector2f read(DataReader in) throws IOException {
        float x = in.readFloat();
        float y = in.readFloat();
        return new Vector2f(x, y);
    }

    public static void write(DataWriter out, Vector2f vec) throws IOException {
        out.writeFloat(vec.x);
        out.writeFloat(vec.y);
    }

    public Vector2f(Vector2f v) {
        this(v.x, v.y);
    }

    public Vector2f(float[] v) {
        this(v[0], v[1]);
    }

    public Vector2f(float x, float y) {
        super(2);
        this.x = x;
        this.y = y;
    }

    @Override
    public float get(int index) {
        switch (index) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
        }
        return 0.0f;
    }

    @Override
    public Vector2f set(int index, float value) {
        switch (index) {
            case 0: {
                return new Vector2f(value, this.y);
            }
            case 1: {
                return new Vector2f(this.x, value);
            }
        }
        return this;
    }

    public float dot(Vector2f that) {
        return this.x * that.x + this.y * that.y;
    }

    public Vector2f normalize() {
        float len = this.length();
        float rx = this.x / len;
        float ry = this.y / len;
        return new Vector2f(rx, ry);
    }

    public Vector2f add(Vector2f that) {
        float rx = this.x + that.x;
        float ry = this.y + that.y;
        return new Vector2f(rx, ry);
    }

    public Vector2f sub(Vector2f that) {
        float rx = this.x - that.x;
        float ry = this.y - that.y;
        return new Vector2f(rx, ry);
    }

    public Vector2f snap(float value) {
        float rx = (float)Math.round(this.x / value) * value;
        float ry = (float)Math.round(this.y / value) * value;
        return new Vector2f(rx, ry);
    }

    public float length() {
        return (float)Math.sqrt(Math.pow(this.x, 2.0) + Math.pow(this.y, 2.0));
    }

    public Vector2f scalar(float mul) {
        float rx = this.x * mul;
        float ry = this.y * mul;
        return new Vector2f(rx, ry);
    }

    public Vector2f scalar(Vector2f that) {
        float rx = this.x * that.x;
        float ry = this.y * that.y;
        return new Vector2f(rx, ry);
    }

    public Vector2f rotate(float angle) {
        if ((angle %= 360.0f) == 0.0f) {
            return this;
        }
        if (angle == 90.0f) {
            return new Vector2f(-this.y, this.x);
        }
        if (angle == 180.0f) {
            return new Vector2f(-this.x, -this.y);
        }
        if (angle == 270.0f) {
            return new Vector2f(this.y, -this.x);
        }
        double radians = Math.toRadians(angle);
        double r = Math.hypot(this.x, this.y);
        double theta = Math.atan2(this.y, this.x);
        double rx = r * Math.cos(theta + radians);
        double ry = r * Math.sin(theta + radians);
        return new Vector2f((float)rx, (float)ry);
    }

    public Vector2f min(Vector2f that) {
        float rx = Math.min(this.x, that.x);
        float ry = Math.min(this.y, that.y);
        return new Vector2f(rx, ry);
    }

    public Vector2f max(Vector2f that) {
        float rx = Math.max(this.x, that.x);
        float ry = Math.max(this.y, that.y);
        return new Vector2f(rx, ry);
    }
}

