/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bsplib.vector;

import java.util.Iterator;

public abstract class VectorXf
implements Iterable<Float> {
    public final int size;

    public VectorXf(int SIZE) {
        this.size = SIZE;
    }

    public abstract float get(int var1);

    public abstract VectorXf set(int var1, float var2);

    public boolean isNaN() {
        for (float value : this) {
            if (!Float.isNaN(value)) continue;
            return true;
        }
        return false;
    }

    public boolean isInfinite() {
        for (float value : this) {
            if (!Float.isInfinite(value)) continue;
            return true;
        }
        return false;
    }

    public boolean isValid() {
        return !this.isNaN() && !this.isInfinite();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof VectorXf)) {
            return false;
        }
        VectorXf that = (VectorXf)obj;
        if (this.size != that.size) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            if (this.get(i) == that.get(i)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = this.size;
        for (float value : this) {
            hash = this.size * this.size * hash + Float.floatToIntBits(value);
        }
        return hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        for (int i = 0; i < this.size; ++i) {
            sb.append(this.get(i));
            if (i == this.size - 1) continue;
            sb.append(", ");
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public Iterator<Float> iterator() {
        return new ValueIterator();
    }

    private class ValueIterator
    implements Iterator<Float> {
        private int index;

        private ValueIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index < VectorXf.this.size;
        }

        @Override
        public Float next() {
            return Float.valueOf(VectorXf.this.get(this.index++));
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Can't remove immutable vector component");
        }
    }
}

