/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bspsrc;

import info.ata4.bsplib.BspFile;
import info.ata4.bsplib.BspFileReader;
import info.ata4.bsplib.PakFile;
import info.ata4.bsplib.nmo.NmoException;
import info.ata4.bsplib.nmo.NmoFile;
import info.ata4.bspsrc.BspFileEntry;
import info.ata4.bspsrc.BspSourceConfig;
import info.ata4.bspsrc.VmfWriter;
import info.ata4.bspsrc.modules.BspDecompiler;
import info.ata4.log.LogUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.output.NullOutputStream;

public class BspSource
implements Runnable {
    private static final Logger L = LogUtils.getLogger();
    public static final String VERSION = "1.4.0";
    private final BspSourceConfig config;

    public BspSource(BspSourceConfig config) {
        this.config = config;
    }

    @Override
    public void run() {
        Set<BspFileEntry> entries;
        long startTime = System.currentTimeMillis();
        if (this.config.isDebug()) {
            this.config.dumpToLog();
        }
        if ((entries = this.config.getFileSet()).isEmpty()) {
            L.severe("No BSP files found");
        } else {
            for (BspFileEntry entry : entries) {
                try {
                    this.decompile(entry);
                    System.gc();
                }
                catch (Exception ex) {
                    L.log(Level.SEVERE, "Decompiling error", ex);
                }
            }
            double duration = (double)(System.currentTimeMillis() - startTime) / 1000.0;
            L.log(Level.INFO, "Processed {0} file(s) in {1} seconds", new Object[]{entries.size(), String.format("%.4f", duration)});
        }
    }

    private void decompile(BspFileEntry entry) {
        BspFileReader reader;
        File bspFile = entry.getBspFile();
        File vmfFile = entry.getVmfFile();
        File nmoFile = entry.getNmoFile();
        File nmosFile = entry.getNmosFile();
        L.log(Level.INFO, "Loading {0}", bspFile);
        try {
            BspFile bsp = new BspFile();
            bsp.setSourceApp(this.config.defaultApp);
            bsp.load(bspFile.toPath());
            if (this.config.loadLumpFiles) {
                bsp.loadLumpFiles();
            }
            if (this.config.unpackEmbedded) {
                try {
                    bsp.getPakFile().unpack(entry.getPakDir().toPath(), path -> !this.config.smartUnpack || !PakFile.isVBSPGeneratedFile(bsp.getName()).test((Path)path));
                }
                catch (IOException ex) {
                    L.log(Level.WARNING, "Can't extract embedded files", ex);
                }
            }
            reader = new BspFileReader(bsp);
            reader.loadAll();
        }
        catch (IOException ex) {
            L.log(Level.SEVERE, "Can't load " + bspFile, ex);
            return;
        }
        NmoFile nmo = null;
        if (reader.getBspFile().getSourceApp().getAppID() == 224260) {
            if (nmoFile.exists()) {
                try {
                    nmo = new NmoFile();
                    nmo.load(nmoFile.toPath(), true);
                    try {
                        nmo.writeAsNmos(nmosFile.toPath());
                    }
                    catch (IOException ex) {
                        L.log(Level.SEVERE, "Error while writing nmos", ex);
                    }
                }
                catch (NmoException | IOException ex) {
                    L.log(Level.SEVERE, "Can't load " + nmoFile, ex);
                    nmo = null;
                }
            } else {
                L.warning("Missing .nmo file! If the bsp is for the objective game mode, its objectives will be missing");
            }
        }
        if (!this.config.isDebug()) {
            L.log(Level.INFO, "BSP version: {0}", reader.getBspFile().getVersion());
            L.log(Level.INFO, "Game: {0}", reader.getBspFile().getSourceApp());
        }
        try (VmfWriter writer = this.getVmfWriter(vmfFile);){
            BspDecompiler decompiler = new BspDecompiler(reader, writer, this.config);
            if (nmo != null) {
                decompiler.setNmoData(nmo);
            }
            decompiler.start();
            L.log(Level.INFO, "Finished decompiling {0}", bspFile);
        }
        catch (IOException ex) {
            L.log(Level.SEVERE, "Can't decompile " + bspFile + " to " + vmfFile, ex);
        }
    }

    private VmfWriter getVmfWriter(File vmfFile) throws IOException {
        if (this.config.nullOutput) {
            return new VmfWriter(new NullOutputStream());
        }
        return new VmfWriter(vmfFile);
    }

    public BspSourceConfig getConfig() {
        return this.config;
    }
}

