/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bspsrc.cli;

import info.ata4.bsplib.app.SourceApp;
import info.ata4.bsplib.app.SourceAppDB;
import info.ata4.bspsrc.BspFileEntry;
import info.ata4.bspsrc.BspSource;
import info.ata4.bspsrc.BspSourceConfig;
import info.ata4.bspsrc.cli.BspSourceCliParseException;
import info.ata4.bspsrc.cli.MultiOptions;
import info.ata4.bspsrc.cli.OptionHelpFormatter;
import info.ata4.bspsrc.modules.geom.BrushMode;
import info.ata4.bspsrc.util.SourceFormat;
import info.ata4.log.LogUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class BspSourceCli {
    private static final Logger L = LogUtils.getLogger();
    private Option helpOpt;
    private Option versionOpt;
    private Option listappidsOpt;
    private Option debugOpt;
    private Option outputOpt;
    private Option recursiveOpt;
    private Option fileListOpt;
    private Options optsMain = new Options();
    private Option nbentsOpt;
    private Option npentsOpt;
    private Option npropsOpt;
    private Option noverlOpt;
    private Option ncubemOpt;
    private Option ndetailsOpt;
    private Option nareapOpt;
    private Option nocclOpt;
    private Option nladderOpt;
    private Option nrotfixOpt;
    private Options optsEntity = new Options();
    private Option fAreapManualOpt;
    private Option fOcclManualOpt;
    private Options optsEntityMapping = new Options();
    private Option nbrushOpt;
    private Option ndispOpt;
    private Option bmodeOpt;
    private Option thicknOpt;
    private Options optsWorld = new Options();
    private Option ntexfixOpt;
    private Option ntooltexfixOpt;
    private Option ftexOpt;
    private Option bftexOpt;
    private Options optsTexture = new Options();
    private Option nvmfOpt;
    private Option nlumpfilesOpt;
    private Option nprotOpt;
    private Option appidOpt;
    private Option nvisgrpOpt;
    private Option ncamsOpt;
    private Option formatOpt;
    private Option unpackOpt;
    private Option nsmartUnpackOpt;
    private Options optsOther = new Options();
    private MultiOptions optsAll = new MultiOptions();

    public static void main(String[] args) {
        LogUtils.configure();
        try {
            BspSourceCli cli = new BspSourceCli();
            cli.run(args);
        }
        catch (Throwable t) {
            L.log(Level.SEVERE, "Fatal BSPSource error", t);
        }
    }

    public BspSourceCli() {
        this.initOptions();
    }

    private void initOptions() {
        BspSourceConfig config = new BspSourceConfig();
        this.helpOpt = new Option("h", "help", false, "Print this help.");
        this.optsMain.addOption(this.helpOpt);
        this.versionOpt = new Option("v", "Print version info.");
        this.optsMain.addOption(this.versionOpt);
        this.debugOpt = new Option("d", "Enable debug mode. Increases verbosity and adds additional data to the VMF file.");
        this.optsMain.addOption(this.debugOpt);
        this.recursiveOpt = new Option("r", "Decompile all files found in the given directory.");
        this.optsMain.addOption(this.recursiveOpt);
        this.outputOpt = Option.builder("o").hasArg().argName("file").desc("Override output path for VMF file(s). Treated as directory if multiple BSP files are provided. \ndefault: <mappath>/<mapname>_d.vmf").build();
        this.optsMain.addOption(this.outputOpt);
        this.fileListOpt = Option.builder("l").hasArg().argName("file").desc("Use a text files with paths as input BSP file list.").build();
        this.optsMain.addOption(this.fileListOpt);
        this.npentsOpt = new Option("no_point_ents", "Don't write any point entities.");
        this.optsEntity.addOption(this.npentsOpt);
        this.nbentsOpt = new Option("no_brush_ents", "Don't write any brush entities.");
        this.optsEntity.addOption(this.nbentsOpt);
        this.npropsOpt = new Option("no_sprp", "Don't write prop_static entities.");
        this.optsEntity.addOption(this.npropsOpt);
        this.noverlOpt = new Option("no_overlays", "Don't write info_overlay entities.");
        this.optsEntity.addOption(this.noverlOpt);
        this.ncubemOpt = new Option("no_cubemaps", "Don't write env_cubemap entities.");
        this.optsEntity.addOption(this.ncubemOpt);
        this.ndetailsOpt = new Option("no_details", "Don't write func_detail entities.");
        this.optsEntity.addOption(this.ndetailsOpt);
        this.nareapOpt = new Option("no_areaportals", "Don't write func_areaportal(_window) entities.");
        this.optsEntity.addOption(this.nareapOpt);
        this.nocclOpt = new Option("no_occluders", "Don't write func_occluder entities.");
        this.optsEntity.addOption(this.nocclOpt);
        this.nladderOpt = new Option("no_ladders", "Don't write func_ladder entities.");
        this.optsEntity.addOption(this.nladderOpt);
        this.nrotfixOpt = new Option("no_rotfix", "Don't fix instance entity brush rotations for Hammer.");
        this.optsEntity.addOption(this.nrotfixOpt);
        this.fAreapManualOpt = new Option("force_manual_areaportal", "Force manual entity mapping for areaportal entities");
        this.optsEntityMapping.addOption(this.fAreapManualOpt);
        this.fOcclManualOpt = new Option("force_manual_occluder", "Force manual entitiy mapping for occluder entities");
        this.optsEntityMapping.addOption(this.fOcclManualOpt);
        this.nbrushOpt = new Option("no_brushes", "Don't write any world brushes.");
        this.optsWorld.addOption(this.nbrushOpt);
        this.ndispOpt = new Option("no_disps", "Don't write displacement surfaces.");
        this.optsWorld.addOption(this.ndispOpt);
        this.bmodeOpt = Option.builder("brushmode").hasArg().argName("enum").desc("Brush decompiling mode:\n" + BrushMode.BRUSHPLANES.name() + "   - brushes and planes\n" + BrushMode.ORIGFACE.name() + "      - original faces only\n" + BrushMode.ORIGFACE_PLUS.name() + " - original + split faces\n" + BrushMode.SPLITFACE.name() + "     - split faces only\ndefault: " + config.brushMode.name()).build();
        this.optsWorld.addOption(this.bmodeOpt);
        this.thicknOpt = Option.builder("thickness").hasArg().argName("float").desc("Thickness of brushes created from flat faces in units.\ndefault: " + config.backfaceDepth).build();
        this.optsWorld.addOption(this.thicknOpt);
        this.ntexfixOpt = new Option("no_texfix", "Don't fix texture names.");
        this.optsTexture.addOption(this.ntexfixOpt);
        this.ntooltexfixOpt = new Option("no_tooltexfix", "Don't fix tool textures.");
        this.optsTexture.addOption(this.ntooltexfixOpt);
        this.ftexOpt = Option.builder("facetex").hasArg().argName("string").desc("Replace all face textures with this one.").build();
        this.optsTexture.addOption(this.ftexOpt);
        this.bftexOpt = Option.builder("bfacetex").hasArg().argName("string").desc("Replace all back-face textures with this one. Used in face-based decompiling modes only.").build();
        this.optsTexture.addOption(this.bftexOpt);
        this.nvmfOpt = new Option("no_vmf", "Don't write any VMF files, read BSP only.");
        this.optsOther.addOption(this.nvmfOpt);
        this.nlumpfilesOpt = new Option("no_lumpfiles", "Don't load lump files (.lmp) associated with the BSP file.");
        this.optsOther.addOption(this.nlumpfilesOpt);
        this.nprotOpt = new Option("no_prot", "Skip decompiling protection checking. Can increase speed when mass-decompiling unprotected maps.");
        this.optsOther.addOption(this.nprotOpt);
        this.listappidsOpt = new Option("appids", "List all available application IDs");
        this.optsOther.addOption(this.listappidsOpt);
        this.nvisgrpOpt = new Option("no_visgroups", "Don't group entities from instances into visgroups.");
        this.optsOther.addOption(this.nvisgrpOpt);
        this.ncamsOpt = new Option("no_cams", "Don't create Hammer cameras above each player spawn.");
        this.optsOther.addOption(this.ncamsOpt);
        this.appidOpt = Option.builder("appid").hasArg().argName("string/int").desc("Overrides game detection by using this Steam Application ID instead.\nUse -appids to list all known app-IDs.").build();
        this.optsOther.addOption(this.appidOpt);
        this.formatOpt = Option.builder("format").hasArg().argName("enum").desc("Sets the VMF format used for the decompiled maps:\n" + SourceFormat.AUTO.name() + " - " + (Object)((Object)SourceFormat.AUTO) + "\n" + SourceFormat.OLD.name() + "  - " + (Object)((Object)SourceFormat.OLD) + "\n" + SourceFormat.NEW.name() + "  - " + (Object)((Object)SourceFormat.NEW) + "\ndefault: " + config.sourceFormat.name()).build();
        this.optsOther.addOption(this.formatOpt);
        this.unpackOpt = new Option("unpack_embedded", "Unpack embedded files in the bsp.");
        this.optsOther.addOption(this.unpackOpt);
        this.nsmartUnpackOpt = new Option("no_smart_unpack", "Disable 'smart' extracting of embedded files.\n Smart extracting automatically skips all files generated by vbsp, that are only relevant to running the map in the engine.");
        this.optsOther.addOption(this.nsmartUnpackOpt);
        this.optsAll.addOptions(this.optsMain).addOptions(this.optsEntity).addOptions(this.optsEntityMapping).addOptions(this.optsWorld).addOptions(this.optsTexture).addOptions(this.optsOther);
    }

    private void run(String[] args) throws IOException, BspSourceCliParseException, ParseException {
        if (args.length == 0) {
            this.printHelp();
            return;
        }
        DefaultParser parser = new DefaultParser();
        CommandLine commandLine = parser.parse(this.optsAll, args);
        if (commandLine.hasOption(this.helpOpt.getOpt())) {
            this.printHelp();
            return;
        }
        if (commandLine.hasOption(this.versionOpt.getOpt())) {
            this.printVersion();
            return;
        }
        if (commandLine.hasOption(this.listappidsOpt.getOpt())) {
            this.printAppIDs();
            return;
        }
        BspSourceConfig config = this.getConfig(commandLine);
        if (config.getFileSet().isEmpty()) {
            L.severe("No BSP file(s) specified");
        } else {
            BspSource bspsrc = new BspSource(config);
            bspsrc.run();
        }
    }

    private void printHelp() {
        System.out.println("BSPSource 1.4.0");
        System.out.println("usage: bspsrc [options] <path> [path...]");
        System.out.println();
        OptionHelpFormatter clHelp = new OptionHelpFormatter();
        clHelp.printHelp("Main options:", this.optsMain);
        clHelp.printHelp("Entity options:", this.optsEntity);
        clHelp.printHelp("Entity mapping options:", this.optsEntityMapping);
        clHelp.printHelp("World brush options:", this.optsWorld);
        clHelp.printHelp("Texture options:", this.optsTexture);
        clHelp.printHelp("Other options:", this.optsOther);
    }

    private void printVersion() {
        System.out.println("BSPSource 1.4.0");
        System.out.println();
        System.out.println("Based on VMEX v0.98g by Rof <rof@mellish.org.uk>");
        System.out.println("Extended and modified by Nico Bergemann <barracuda415@yahoo.de>");
    }

    private void printAppIDs() {
        System.out.printf("%6s  %s\n", "ID", "Name");
        List<SourceApp> apps = SourceAppDB.getInstance().getAppList();
        for (SourceApp app : apps) {
            System.out.printf("%6d  %s\n", app.getAppID(), app.getName());
        }
    }

    public BspSourceConfig getConfig(CommandLine cl) throws IOException, BspSourceCliParseException {
        String[] argsLeft;
        BspSourceConfig config = new BspSourceConfig();
        HashSet<BspFileEntry> files = new HashSet<BspFileEntry>();
        config.setDebug(cl.hasOption(this.debugOpt.getOpt()));
        File outputFile = cl.hasOption(this.outputOpt.getOpt()) ? new File(cl.getOptionValue(this.outputOpt.getOpt())) : null;
        boolean recursive = cl.hasOption(this.recursiveOpt.getOpt());
        if (cl.hasOption(this.fileListOpt.getOpt())) {
            Files.readAllLines(Paths.get(cl.getOptionValue(this.fileListOpt.getOpt()), new String[0])).stream().map(File::new).map(filePath -> new BspFileEntry((File)filePath, outputFile)).forEach(files::add);
        }
        config.writePointEntities = !cl.hasOption(this.npentsOpt.getOpt());
        config.writeBrushEntities = !cl.hasOption(this.nbentsOpt.getOpt());
        config.writeStaticProps = !cl.hasOption(this.npropsOpt.getOpt());
        config.writeOverlays = !cl.hasOption(this.noverlOpt.getOpt());
        config.writeDisp = !cl.hasOption(this.ndispOpt.getOpt());
        config.writeAreaportals = !cl.hasOption(this.nareapOpt.getOpt());
        config.writeOccluders = !cl.hasOption(this.nocclOpt.getOpt());
        config.writeCubemaps = !cl.hasOption(this.ncubemOpt.getOpt());
        config.writeDetails = !cl.hasOption(this.ndetailsOpt.getOpt());
        config.writeLadders = !cl.hasOption(this.nladderOpt.getOpt());
        config.apForceManualMapping = cl.hasOption(this.fAreapManualOpt.getOpt());
        config.occForceManualMapping = cl.hasOption(this.fOcclManualOpt.getOpt());
        boolean bl = config.writeWorldBrushes = !cl.hasOption(this.nbrushOpt.getOpt());
        if (cl.hasOption(this.bmodeOpt.getOpt())) {
            String modeStr = cl.getOptionValue(this.bmodeOpt.getOpt());
            config.brushMode = BspSourceCli.parseEnum(BrushMode.class, modeStr).orElseThrow(() -> new BspSourceCliParseException("Invalid brush mode: " + modeStr));
        }
        if (cl.hasOption(this.formatOpt.getOpt())) {
            String formatStr = cl.getOptionValue(this.formatOpt.getOpt());
            config.sourceFormat = BspSourceCli.parseEnum(SourceFormat.class, formatStr).orElseThrow(() -> new BspSourceCliParseException("Invalid source format: " + formatStr));
        }
        if (cl.hasOption(this.thicknOpt.getOpt())) {
            String thicknessStr = cl.getOptionValue(this.thicknOpt.getOpt());
            try {
                config.backfaceDepth = Float.parseFloat(thicknessStr);
            }
            catch (NumberFormatException e) {
                throw new BspSourceCliParseException("Invalid thickness: " + thicknessStr);
            }
        }
        config.fixCubemapTextures = !cl.hasOption(this.ntexfixOpt.getOpt());
        boolean bl2 = config.fixToolTextures = !cl.hasOption(this.ntooltexfixOpt.getOpt());
        if (cl.hasOption(this.ftexOpt.getOpt())) {
            config.faceTexture = cl.getOptionValue(this.ftexOpt.getOpt());
        }
        if (cl.hasOption(this.bftexOpt.getOpt())) {
            config.backfaceTexture = cl.getOptionValue(this.bftexOpt.getOpt());
        }
        config.loadLumpFiles = !cl.hasOption(this.nlumpfilesOpt.getOpt());
        config.skipProt = cl.hasOption(this.nprotOpt.getOpt());
        config.fixEntityRot = !cl.hasOption(this.nrotfixOpt.getOpt());
        config.nullOutput = cl.hasOption(this.nvmfOpt.getOpt());
        config.writeVisgroups = !cl.hasOption(this.nvisgrpOpt.getOpt());
        config.writeCameras = !cl.hasOption(this.ncamsOpt.getOpt());
        config.unpackEmbedded = cl.hasOption(this.unpackOpt.getOpt());
        boolean bl3 = config.smartUnpack = !cl.hasOption(this.nsmartUnpackOpt.getOpt());
        if (cl.hasOption(this.appidOpt.getOpt())) {
            String appidStr = cl.getOptionValue(this.appidOpt.getOpt()).toUpperCase();
            try {
                int appid = Integer.parseInt(appidStr);
                config.defaultApp = SourceAppDB.getInstance().fromID(appid);
            }
            catch (NumberFormatException e) {
                throw new BspSourceCliParseException("Invalid App-ID: " + appidStr);
            }
        }
        for (String arg : argsLeft = cl.getArgs()) {
            Path path = Paths.get(arg, new String[0]);
            if (Files.isDirectory(path, new LinkOption[0])) {
                PathMatcher bspPathMatcher = path.getFileSystem().getPathMatcher("blob:*.bsp");
                try (Stream<Path> pathStream = Files.walk(path, recursive ? Integer.MAX_VALUE : 0, new FileVisitOption[0]);){
                    pathStream.filter(filePath -> Files.isRegularFile(filePath, new LinkOption[0])).filter(bspPathMatcher::matches).map(filePath -> new BspFileEntry(filePath.toFile(), outputFile)).forEach(files::add);
                    continue;
                }
            }
            files.add(new BspFileEntry(path.toFile(), outputFile));
        }
        config.addFiles(files);
        return config;
    }

    private static <E extends Enum<E>> Optional<E> parseEnum(Class<E> eClass, String value) {
        try {
            return Optional.of(Enum.valueOf(eClass, value));
        }
        catch (IllegalArgumentException e) {
            try {
                return Optional.of(((Enum[])eClass.getEnumConstants())[Integer.parseInt(value)]);
            }
            catch (ArrayIndexOutOfBoundsException | NumberFormatException runtimeException) {
                return Optional.empty();
            }
        }
    }
}

