/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bspsrc.modules;

import info.ata4.bsplib.BspFileReader;
import info.ata4.bsplib.lump.Lump;
import info.ata4.bsplib.lump.LumpType;
import info.ata4.bspsrc.modules.ModuleRead;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.NullOutputStream;

public class BspChecksum
extends ModuleRead {
    public BspChecksum(BspFileReader reader) {
        super(reader);
    }

    public long getMapCRC() throws IOException {
        CRC32 crc = new CRC32();
        for (Lump lump : this.bspFile.getLumps()) {
            if (lump.getType() == LumpType.LUMP_ENTITIES) continue;
            try (CheckedInputStream in = new CheckedInputStream(lump.getInputStream(), crc);){
                IOUtils.copy((InputStream)in, (OutputStream)new NullOutputStream());
            }
        }
        return crc.getValue();
    }

    public long getFileCRC() throws IOException {
        return FileUtils.checksumCRC32(this.bspFile.getFile().toFile());
    }
}

