/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bspsrc.modules;

import info.ata4.bsplib.BspFileReader;
import info.ata4.bsplib.nmo.NmoFile;
import info.ata4.bspsrc.BspSourceConfig;
import info.ata4.bspsrc.VmfWriter;
import info.ata4.bspsrc.modules.BspProtection;
import info.ata4.bspsrc.modules.ModuleDecompile;
import info.ata4.bspsrc.modules.VmfMeta;
import info.ata4.bspsrc.modules.entity.EntitySource;
import info.ata4.bspsrc.modules.geom.BrushMode;
import info.ata4.bspsrc.modules.geom.BrushSource;
import info.ata4.bspsrc.modules.geom.FaceSource;
import info.ata4.bspsrc.modules.texture.TextureSource;
import info.ata4.bspsrc.util.WindingFactory;
import info.ata4.log.LogUtils;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BspDecompiler
extends ModuleDecompile {
    private static final Logger L = LogUtils.getLogger();
    private final BspSourceConfig config;
    private final TextureSource texsrc;
    private final BrushSource brushsrc;
    private final FaceSource facesrc;
    private final EntitySource entsrc;
    private final BspProtection bspprot;
    private final VmfMeta vmfmeta;

    public BspDecompiler(BspFileReader reader, VmfWriter writer, BspSourceConfig config) {
        super(reader, writer);
        WindingFactory.clearCache();
        this.config = config;
        this.texsrc = new TextureSource(reader);
        this.bspprot = new BspProtection(reader, this.texsrc);
        this.vmfmeta = new VmfMeta(reader, writer);
        this.brushsrc = new BrushSource(reader, writer, config, this.texsrc, this.bspprot, this.vmfmeta);
        this.facesrc = new FaceSource(reader, writer, config, this.texsrc, this.vmfmeta);
        this.entsrc = new EntitySource(reader, writer, config, this.brushsrc, this.facesrc, this.texsrc, this.bspprot, this.vmfmeta);
    }

    public void start() {
        this.texsrc.setFixTextureNames(this.config.fixCubemapTextures);
        if (this.bspFile.getSourceApp().getAppID() == 2600) {
            this.texsrc.setFixToolTextures(false);
        } else {
            this.texsrc.setFixToolTextures(this.config.fixToolTextures);
        }
        if (!this.config.skipProt) {
            this.checkProtection();
        }
        this.vmfmeta.setComment("Decompiled by BSPSource v1.4.0 from " + this.bspFile.getName());
        this.vmfmeta.writeWorldHeader();
        if (this.config.writeWorldBrushes) {
            this.writeBrushes();
        }
        this.vmfmeta.writeWorldFooter();
        if (this.config.isWriteEntities()) {
            this.writeEntities();
        }
        if (this.config.writeVisgroups) {
            this.vmfmeta.writeVisgroups();
        }
        if (this.config.writeCameras) {
            this.vmfmeta.writeCameras();
        }
    }

    private void checkProtection() {
        if (!this.bspprot.check()) {
            return;
        }
        L.log(Level.WARNING, "{0} contains anti-decompiling flags or is obfuscated!", this.reader.getBspFile().getName());
        L.log(Level.WARNING, "Detected methods:");
        List<String> methods = this.bspprot.getProtectionMethods();
        for (String method : methods) {
            L.warning(method);
        }
    }

    private void writeBrushes() {
        switch (this.config.brushMode) {
            case BRUSHPLANES: {
                this.brushsrc.writeBrushes();
                break;
            }
            case ORIGFACE: {
                this.facesrc.writeOrigFaces();
                break;
            }
            case ORIGFACE_PLUS: {
                this.facesrc.writeOrigFacesPlus();
                break;
            }
            case SPLITFACE: {
                this.facesrc.writeFaces();
                break;
            }
        }
        if (this.config.brushMode == BrushMode.BRUSHPLANES) {
            this.facesrc.writeDispFaces();
        }
    }

    private void writeEntities() {
        if (this.config.isWriteEntities()) {
            this.entsrc.writeEntities();
        }
        if (this.config.writeBrushEntities && this.config.writeDetails && this.config.brushMode == BrushMode.BRUSHPLANES) {
            this.entsrc.writeDetails();
        }
        if (this.config.writePointEntities) {
            if (this.config.writeOverlays) {
                this.entsrc.writeOverlays();
            }
            if (this.config.writeStaticProps) {
                this.entsrc.writeStaticProps();
            }
            if (this.config.writeCubemaps) {
                this.entsrc.writeCubemaps();
            }
            if (this.config.writeLadders && this.bspFile.getSourceApp().getAppID() != 730) {
                this.entsrc.writeLadders();
            }
        }
    }

    public void setNmoData(NmoFile nmo) {
        this.entsrc.setNmo(nmo);
    }
}

