/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bspsrc.modules;

import info.ata4.bsplib.BspFileReader;
import info.ata4.bsplib.entity.Entity;
import info.ata4.bspsrc.VmfWriter;
import info.ata4.bspsrc.modules.ModuleDecompile;
import info.ata4.bspsrc.modules.entity.Camera;
import info.ata4.log.LogUtils;
import info.ata4.util.AlphanumComparator;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class VmfMeta
extends ModuleDecompile {
    private static final Logger L = LogUtils.getLogger();
    private static final Random RANDOM = new Random();
    private Map<Integer, Integer> faceUIDs = new HashMap<Integer, Integer>();
    private Map<Integer, Integer> origFaceUIDs = new HashMap<Integer, Integer>();
    private Map<Short, Integer> dispinfoUIDs = new HashMap<Short, Integer>();
    private Set<Integer> uidbl = new HashSet<Integer>();
    private int uid = 0;
    private Map<List<String>, Integer> reservedVisgroups = new HashMap<List<String>, Integer>();
    private int visgroupIndex = 0;
    private Visgroup rootVisgroup = new Visgroup("root", null);
    private List<Camera> cameras = new ArrayList<Camera>();
    private Entity worldspawn;
    private String comment;

    public VmfMeta(BspFileReader reader, VmfWriter writer) {
        super(reader, writer);
        if (this.bsp.entities.isEmpty()) {
            L.warning("Couldn't get Worldspawn-entity, because entity list is empty (Probably because map uses external lump files). The map may be missing some information like skybox or detail sprites...");
        } else {
            this.worldspawn = this.bsp.entities.get(0);
            if (this.worldspawn.getValue("comment") != null) {
                L.log(Level.INFO, "Map comment: {0}", this.worldspawn.getValue("comment"));
            }
        }
    }

    public Set<Integer> getUIDBlackList() {
        return this.uidbl;
    }

    public int getUID() {
        if (this.uidbl.isEmpty()) {
            return this.uid++;
        }
        do {
            ++this.uid;
        } while (this.uidbl.contains(this.uid));
        return this.uid;
    }

    public int getFaceUID(int iface) {
        if (this.faceUIDs.containsKey(iface)) {
            return this.faceUIDs.get(iface);
        }
        int ioface = this.bsp.faces.get((int)iface).origFace;
        if (this.origFaceUIDs.containsKey(ioface)) {
            return this.origFaceUIDs.get(ioface);
        }
        return -1;
    }

    public Integer setFaceUID(int iface, int id) {
        return this.faceUIDs.put(iface, id);
    }

    public Integer setOrigFaceUID(int iface, int id) {
        return this.origFaceUIDs.put(iface, id);
    }

    public int getDispInfoUID(short idispinfo) {
        if (this.dispinfoUIDs.containsKey(idispinfo)) {
            return this.dispinfoUIDs.get(idispinfo);
        }
        return -1;
    }

    public Integer setDispInfoUID(short idispinfo, int id) {
        return this.dispinfoUIDs.put(idispinfo, id);
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getComment() {
        return this.comment;
    }

    public void writeWorldHeader() {
        this.writer.start("world");
        this.writer.put("id", this.getUID());
        if (this.worldspawn != null) {
            this.writer.put(this.worldspawn);
        }
        if (this.comment != null) {
            this.writer.put("comment", this.comment);
        }
        this.writer.put("classname", "worldspawn");
    }

    public void writeWorldFooter() {
        this.writer.end("world");
    }

    public void writeVisgroups() {
        if (this.rootVisgroup.visgroups.isEmpty()) {
            return;
        }
        this.writer.start("visgroups");
        this.rootVisgroup.visgroups.forEach(this::writeVisgroup);
        this.writer.end("visgroups");
    }

    private void writeVisgroup(Visgroup visgroup) {
        if (!visgroup.isTreeUsed()) {
            return;
        }
        this.writer.start("visgroup");
        this.writer.put("name", visgroup.name);
        this.writer.put("visgroupid", visgroup.id);
        this.writer.put("color", String.format("%s %s %s", visgroup.getColor().getRed(), visgroup.getColor().getBlue(), visgroup.getColor().getGreen()));
        visgroup.visgroups.forEach(this::writeVisgroup);
        this.writer.end("visgroup");
    }

    public void writeMetaVisgroup(String visgroupName) {
        this.writeMetaVisgroups(Collections.singletonList(this.rootVisgroup.getVisgroup(visgroupName)));
    }

    public void writeMetaVisgroups(List<Visgroup> visgroups) {
        this.writer.start("editor");
        for (Visgroup vg : visgroups) {
            if (vg == this.rootVisgroup) {
                throw new IllegalArgumentException("Root visgroup cannot be written");
            }
            if (vg.getRootVisgroup() != this.rootVisgroup) {
                throw new IllegalArgumentException(String.format("Visgroup '%s' is not part of this VmfMetas' root visgroup", String.join((CharSequence)"/", vg.getVisgroupPath())));
            }
            this.writer.put("visgroupid", vg.id);
            vg.used = true;
        }
        this.writer.end("editor");
    }

    public Visgroup visgroups() {
        return this.rootVisgroup;
    }

    private int getNewVisgroupId(Visgroup vg) {
        return Optional.ofNullable(this.reservedVisgroups.get(vg.getVisgroupPath())).orElseGet(() -> IntStream.generate(() -> this.visgroupIndex++).filter(id -> !this.reservedVisgroups.containsValue(id)).findFirst().orElseThrow(RuntimeException::new));
    }

    public void reserveVisgroupId(int visgroupId, String ... visgroupNames) throws VisgroupException {
        this.reserveVisgroupId(visgroupId, Arrays.asList(visgroupNames));
    }

    public void reserveVisgroupId(int visgroupId, List<String> visgroupPath) throws VisgroupException {
        if (visgroupPath.isEmpty() || visgroupPath.stream().anyMatch(String::isEmpty)) {
            throw new IllegalArgumentException("Invalid visgroup path: " + visgroupPath);
        }
        ArrayList<String> visgroupPathFixed = new ArrayList<String>(visgroupPath);
        visgroupPathFixed.add(0, this.rootVisgroup.name);
        if (this.rootVisgroup.containsVisgroupId(visgroupId)) {
            throw new VisgroupException(String.format("Tried to reserve already taken visgroup id %d to '%s'", visgroupId, String.join((CharSequence)"/", visgroupPathFixed)));
        }
        Optional<List> duplicatedVisgroupPath = this.reservedVisgroups.entrySet().stream().filter(entry -> (Integer)entry.getValue() == visgroupId).map(Map.Entry::getKey).findAny();
        if (duplicatedVisgroupPath.isPresent()) {
            throw new VisgroupException(String.format("Tried to reserve visgroup %s with id %d, which is already reserved by %s", String.join((CharSequence)"/", visgroupPathFixed), visgroupId, String.join((CharSequence)"/", duplicatedVisgroupPath.get())));
        }
        if (this.reservedVisgroups.containsKey(visgroupPathFixed)) {
            L.warning(String.format("Visgroup '%s' is already reserved with id %d, overwriting with %d", String.join((CharSequence)"/", visgroupPathFixed), this.reservedVisgroups.get(visgroupPathFixed), visgroupId));
        }
        this.reservedVisgroups.put(new ArrayList<String>(visgroupPathFixed), visgroupId);
    }

    public void writeCameras() {
        this.writer.start("cameras");
        if (this.cameras.isEmpty()) {
            this.writer.put("activecamera", -1);
        } else {
            this.writer.put("activecamera", 0);
            for (Camera camera : this.cameras) {
                this.writer.start("camera");
                this.writer.put("position", camera.pos, 2);
                this.writer.put("look", camera.look, 2);
                this.writer.end("camera");
            }
        }
        this.writer.end("cameras");
    }

    public List<Camera> getCameras() {
        return this.cameras;
    }

    public class Visgroup {
        private final String name;
        private final int id;
        private Color color;
        private final Visgroup parent;
        private final SortedSet<Visgroup> visgroups = new TreeSet<Visgroup>(Comparator.comparing(vg -> vg.name, AlphanumComparator.COMPARATOR));
        private boolean used = false;

        private Visgroup(String name, Visgroup parent) {
            if (name.isEmpty()) {
                throw new IllegalArgumentException("A visgroup cannot have an empty name");
            }
            this.name = name;
            this.color = this.getNewVisgroupColor();
            this.parent = parent;
            if (parent != null) {
                parent.visgroups.add(this);
            }
            this.id = VmfMeta.this.getNewVisgroupId(this);
        }

        public Visgroup getVisgroup(String visgroupName) {
            if (this.name.isEmpty()) {
                throw new IllegalArgumentException("A visgroup cannot have an empty name");
            }
            return this.visgroups.stream().filter(visgroup -> visgroup.name.equals(visgroupName)).findAny().orElseGet(() -> new Visgroup(visgroupName, this));
        }

        private Visgroup getRootVisgroup() {
            Visgroup root = this;
            while (root.parent != null) {
                root = root.parent;
            }
            return root;
        }

        private List<String> getVisgroupPath() {
            ArrayList<String> path = new ArrayList<String>();
            path.add(this.name);
            Visgroup vg = this;
            while ((vg = vg.parent) != null) {
                path.add(0, vg.name);
            }
            return path;
        }

        private boolean isTreeUsed() {
            return this.visgroupStream().anyMatch(vg -> vg.used);
        }

        private boolean containsVisgroupId(int id) {
            return this.visgroupStream().anyMatch(vg -> vg.id == id);
        }

        private Stream<Visgroup> visgroupStream() {
            return Stream.concat(Stream.of(this), this.visgroups.stream().flatMap(Visgroup::visgroupStream));
        }

        public Visgroup setColor(Color color) {
            Objects.requireNonNull(color);
            this.color = color;
            return this;
        }

        public Color getColor() {
            return this.color;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Visgroup visgroup = (Visgroup)o;
            return this.id == visgroup.id;
        }

        public int hashCode() {
            return this.id;
        }

        private Color getNewVisgroupColor() {
            float hue = RANDOM.nextFloat();
            float saturation = RANDOM.nextFloat() * 0.8f + 0.1f;
            float luminance = RANDOM.nextFloat() * 0.4f + 0.5f;
            return Color.getHSBColor(hue, saturation, luminance);
        }
    }

    public static class VisgroupException
    extends Exception {
        public VisgroupException() {
        }

        public VisgroupException(String message) {
            super(message);
        }

        public VisgroupException(String message, Throwable cause) {
            super(message, cause);
        }

        public VisgroupException(Throwable cause) {
            super(cause);
        }

        public VisgroupException(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
            super(message, cause, enableSuppression, writableStackTrace);
        }
    }
}

