/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bspsrc.util;

import info.ata4.bsplib.entity.Entity;
import info.ata4.bsplib.struct.BspData;
import info.ata4.bsplib.struct.DAreaportal;
import info.ata4.bsplib.struct.DBrush;
import info.ata4.bsplib.util.VectorUtil;
import info.ata4.bspsrc.BspSourceConfig;
import info.ata4.bspsrc.VmfWriter;
import info.ata4.bspsrc.modules.VmfMeta;
import info.ata4.bspsrc.modules.geom.FaceSource;
import info.ata4.bspsrc.util.Winding;
import info.ata4.bspsrc.util.WindingFactory;
import info.ata4.log.LogUtils;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class AreaportalMapper {
    private static final Logger L = LogUtils.getLogger();
    private BspSourceConfig config;
    private BspData bsp;
    private ArrayList<AreaportalHelper> areaportalHelpers = new ArrayList();
    private ArrayList<DBrush> areaportalBrushes = new ArrayList();

    public AreaportalMapper(BspData bsp, BspSourceConfig config) {
        this.bsp = bsp;
        this.config = config;
        if (this.checkAreaportal()) {
            L.warning("Invalid areaportals, map was probably compiled with errors! Errors should be expected");
        }
        this.prepareApHelpers();
        this.prepareApBrushes();
    }

    private boolean checkAreaportal() {
        return this.bsp.areaportals.stream().filter(dAreaportal -> dAreaportal.portalKey != 0).anyMatch(dAreaportal -> dAreaportal.clipPortalVerts == 0);
    }

    private void prepareApHelpers() {
        for (DAreaportal dAreaportal : this.bsp.areaportals) {
            if (dAreaportal.portalKey == 0) continue;
            Optional<AreaportalHelper> matchingApHelper = this.areaportalHelpers.stream().filter(apHelper -> apHelper.winding.matches(WindingFactory.fromAreaportal(this.bsp, dAreaportal))).findAny();
            if (matchingApHelper.isPresent()) {
                matchingApHelper.get().portalID.add(Integer.valueOf(dAreaportal.portalKey));
                continue;
            }
            AreaportalHelper areaportalHelper = new AreaportalHelper();
            areaportalHelper.winding = WindingFactory.fromAreaportal(this.bsp, dAreaportal);
            areaportalHelper.portalID.add(Integer.valueOf(dAreaportal.portalKey));
            this.areaportalHelpers.add(areaportalHelper);
        }
        this.areaportalHelpers.sort(Comparator.comparingInt(apHelper -> apHelper.portalID.first()));
    }

    private void prepareApBrushes() {
        this.areaportalBrushes.addAll(this.bsp.brushes.stream().filter(DBrush::isAreaportal).collect(Collectors.toList()));
    }

    private Map<Integer, Integer> manualMapping() {
        Map<DBrush, Map> brushProbMapping = this.areaportalBrushes.stream().collect(Collectors.toMap(dBrush -> dBrush, this::areaportalBrushProb));
        brushProbMapping.entrySet().removeIf(dBrushMapEntry -> ((Map)dBrushMapEntry.getValue()).isEmpty());
        HashMap<Integer, Integer> brushMapping = new HashMap<Integer, Integer>();
        HashMap<DBrush, Map> mappingQueue = new HashMap<DBrush, Map>();
        Comparator<Map.Entry> mappingQueueComparator = Comparator.comparingDouble(entry -> ((Map)entry.getValue()).entrySet().stream().max(Comparator.comparingDouble(Map.Entry::getValue)).map(Map.Entry::getValue).get());
        while (!brushProbMapping.isEmpty()) {
            mappingQueue.clear();
            mappingQueue.putAll(brushProbMapping.entrySet().stream().filter(dBrushMapEntry -> ((Map)dBrushMapEntry.getValue()).size() == 1).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
            if (mappingQueue.isEmpty()) {
                brushProbMapping.entrySet().stream().max(mappingQueueComparator).ifPresent(entry -> mappingQueue.put((DBrush)entry.getKey(), (Map)entry.getValue()));
            }
            mappingQueue.entrySet().stream().sorted(mappingQueueComparator).forEachOrdered(entry -> {
                DBrush dBrush = (DBrush)entry.getKey();
                AreaportalHelper apHelper = ((Map)entry.getValue()).entrySet().stream().max(Comparator.comparingDouble(Map.Entry::getValue)).map(Map.Entry::getKey).get();
                if (!apHelper.portalID.isEmpty()) {
                    int portalID = apHelper.portalID.first();
                    brushProbMapping.entrySet().stream().flatMap(dBrushMapEntry -> ((Map)dBrushMapEntry.getValue()).keySet().stream()).forEach(areaportalHelper -> areaportalHelper.portalID.removeIf(integer -> integer == portalID));
                    brushProbMapping.forEach((key, value) -> value.entrySet().removeIf(apEntry -> ((AreaportalHelper)apEntry.getKey()).portalID.isEmpty()));
                    brushMapping.put(portalID, this.bsp.brushes.indexOf(dBrush));
                } else {
                    L.warning("Couldn't find valid Areaportal mapping for brush " + this.bsp.brushes.indexOf(dBrush));
                }
                brushProbMapping.remove(dBrush);
            });
            brushProbMapping.entrySet().removeIf(entry -> ((Map)entry.getValue()).isEmpty());
        }
        if (this.config.isDebug()) {
            Map<DBrush, Map> debugBrushProbMapping = this.areaportalBrushes.stream().collect(Collectors.toMap(dBrush -> dBrush, this::areaportalBrushProb));
            for (Entity entity : this.bsp.entities) {
                if (!entity.getClassName().startsWith("func_areaportal")) continue;
                try {
                    DBrush brush;
                    Map probabilities;
                    Integer brushIndex = brushMapping.get(Integer.valueOf(entity.getValue("portalnumber")));
                    if (brushIndex == null || (probabilities = debugBrushProbMapping.get(brush = this.bsp.brushes.get(brushIndex))) == null) continue;
                    probabilities.forEach((areaportal, percentage) -> entity.setValue("areaportalProb" + areaportal.portalID.stream().map(Object::toString).collect(Collectors.joining(", ", "[", "]")), percentage));
                }
                catch (NumberFormatException e) {
                    L.log(Level.FINE, "func_areaportal portalnumber property is missing or invalid", e);
                }
            }
        }
        return brushMapping;
    }

    private Map<AreaportalHelper, Double> areaportalBrushProb(DBrush dBrush) {
        return this.bsp.brushSides.subList(dBrush.fstside, dBrush.fstside + dBrush.numside).stream().flatMap(brushSide -> this.areaportalHelpers.stream().map(apHelper -> new AbstractMap.SimpleEntry<AreaportalHelper, Double>(new AreaportalHelper((AreaportalHelper)apHelper), VectorUtil.matchingAreaPercentage(apHelper.getFirstDAreaportal(), dBrush, brushSide, this.bsp))).filter(entry -> (Double)entry.getValue() != 0.0)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Map<Integer, Integer> orderedMapping() {
        int areaportalIDCount = this.areaportalHelpers.stream().mapToInt(apHelper -> apHelper.portalID.size()).sum();
        int areaportalBrushCount = this.areaportalBrushes.size();
        return IntStream.range(0, Math.min(areaportalIDCount, areaportalBrushCount)).boxed().collect(Collectors.toMap(i -> i + 1, i -> this.bsp.brushes.indexOf(this.areaportalBrushes.get((int)i))));
    }

    public Map<Integer, Integer> getApBrushMapping() {
        if (!this.config.writeAreaportals) {
            return Collections.emptyMap();
        }
        if (this.areaportalHelpers.size() == 0) {
            L.info("No areaportals to reallocate...");
            return Collections.emptyMap();
        }
        if (this.config.apForceManualMapping) {
            L.info("Forced manual areaportal mapping method");
            return ApMappingMode.MANUAL.map(this);
        }
        if ((long)this.areaportalHelpers.stream().mapToInt(value -> value.portalID.size()).sum() == this.bsp.brushes.stream().filter(DBrush::isAreaportal).count()) {
            L.info("Equal amount of areaporal entities and areaportal brushes. Using '" + (Object)((Object)ApMappingMode.ORDERED) + "' method");
            return ApMappingMode.ORDERED.map(this);
        }
        L.info("Unequal amount of areaporal entities and areaportal brushes. Falling back to '" + (Object)((Object)ApMappingMode.MANUAL) + "' method");
        return ApMappingMode.MANUAL.map(this);
    }

    public void writeDebugPortals(VmfWriter writer, VmfMeta vmfMeta, FaceSource faceSource) {
        for (AreaportalHelper areaportalHelper : this.areaportalHelpers) {
            writer.start("entity");
            writer.put("id", vmfMeta.getUID());
            writer.put("classname", "func_detail");
            writer.put("areaportalIDs", areaportalHelper.portalID.stream().map(Object::toString).collect(Collectors.joining(", ")));
            faceSource.writePolygon(areaportalHelper.winding, "tools/toolsskip", true);
            vmfMeta.writeMetaVisgroups(areaportalHelper.portalID.stream().map(id -> vmfMeta.visgroups().getVisgroup("AreaportalID").getVisgroup(String.valueOf(id))).collect(Collectors.toList()));
            writer.end("entity");
        }
    }

    private class AreaportalHelper {
        public final TreeSet<Integer> portalID = new TreeSet();
        public Winding winding;

        public AreaportalHelper() {
        }

        public AreaportalHelper(AreaportalHelper apHelper) {
            this.portalID.addAll(apHelper.portalID);
            this.winding = apHelper.winding;
        }

        public DAreaportal getFirstDAreaportal() {
            return ((AreaportalMapper)AreaportalMapper.this).bsp.areaportals.stream().filter(areaportal -> areaportal.portalKey == this.portalID.first()).findAny().orElseThrow(() -> new RuntimeException("Areaportalhelper points to non existing dAreaportal " + this.portalID.first()));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AreaportalHelper that = (AreaportalHelper)o;
            if (!this.portalID.equals(that.portalID)) {
                return false;
            }
            return Objects.equals(this.winding, that.winding);
        }

        public int hashCode() {
            int result = this.portalID.hashCode();
            result = 31 * result + (this.winding != null ? this.winding.hashCode() : 0);
            return result;
        }
    }

    public static enum ApMappingMode {
        MANUAL(rec$ -> AreaportalMapper.access$100((AreaportalMapper)rec$)),
        ORDERED(rec$ -> AreaportalMapper.access$000((AreaportalMapper)rec$));

        private Function<AreaportalMapper, Map<Integer, Integer>> mapper;

        private ApMappingMode(Function<AreaportalMapper, Map<Integer, Integer>> mapper) {
            this.mapper = mapper;
        }

        public Map<Integer, Integer> map(AreaportalMapper apMapper) {
            return this.mapper.apply(apMapper);
        }

        public String toString() {
            return super.toString().substring(0, 1).toUpperCase() + super.toString().substring(1).toLowerCase();
        }
    }
}

