/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.io;

import info.ata4.io.Seekable;
import info.ata4.io.Swappable;
import info.ata4.io.buffer.source.BufferedSource;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteOrder;

public abstract class DataBridge
implements Seekable,
Closeable,
Swappable {
    protected final BufferedSource buf;

    public DataBridge(BufferedSource buf) {
        this.buf = buf;
    }

    @Override
    public ByteOrder order() {
        return this.buf.order();
    }

    @Override
    public void order(ByteOrder order) {
        this.buf.order(order);
    }

    @Override
    public long position() throws IOException {
        return this.buf.position();
    }

    @Override
    public void position(long newPos) throws IOException {
        this.buf.position(newPos);
    }

    @Override
    public long size() throws IOException {
        return this.buf.size();
    }

    @Override
    public void seek(long where, Seekable.Origin whence) throws IOException {
        long pos = 0L;
        switch (whence) {
            case BEGINNING: {
                pos = where;
                break;
            }
            case CURRENT: {
                pos = this.position() + where;
                break;
            }
            case END: {
                pos = this.size() - where;
            }
        }
        this.position(pos);
    }

    @Override
    public long remaining() throws IOException {
        return this.size() - this.position();
    }

    @Override
    public boolean hasRemaining() throws IOException {
        return this.remaining() > 0L;
    }

    @Override
    public void align(int align) throws IOException {
        if (align < 0) {
            throw new IllegalArgumentException();
        }
        if (align == 0) {
            return;
        }
        long pos = this.position();
        long rem = pos % (long)align;
        if (rem != 0L) {
            this.position(pos + (long)align - rem);
        }
    }

    @Override
    public void close() throws IOException {
        this.buf.close();
    }
}

