/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.io.lzma;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class LzmaProps {
    protected static final int kDicLogSizeMaxCompress = 29;
    private boolean includeProps = true;
    private boolean includeSize = true;
    private int numLiteralContextBits = 3;
    private int numLiteralPosStateBits = 0;
    private int posStateBits = 2;
    private int dictionarySize = 0x400000;
    private long uncompressedSize = -1L;

    public boolean isIncludeProps() {
        return this.includeProps;
    }

    public void setIncludeProps(boolean includeProps) {
        this.includeProps = includeProps;
    }

    public boolean isIncludeSize() {
        return this.includeSize;
    }

    public void setIncludeSize(boolean includeSize) {
        this.includeSize = includeSize;
    }

    public int getPropSize() {
        int size = 0;
        if (this.isIncludeSize()) {
            size += 8;
        }
        if (this.isIncludeProps()) {
            size += 5;
        }
        return size;
    }

    public int getNumLiteralContextBits() {
        return this.numLiteralContextBits;
    }

    public void setNumLiteralContextBits(int lc) {
        if (lc < 0 || lc > 8) {
            throw new IllegalArgumentException();
        }
        this.numLiteralContextBits = lc;
    }

    public int getNumLiteralPosStateBits() {
        return this.numLiteralPosStateBits;
    }

    public void setNumLiteralPosStateBits(int lp) {
        if (lp < 0 || lp > 4) {
            throw new IllegalArgumentException();
        }
        this.numLiteralPosStateBits = lp;
    }

    public int getPosStateBits() {
        return this.posStateBits;
    }

    public void setPosStateBits(int pb) {
        if (pb < 0 || pb > 4) {
            throw new IllegalArgumentException();
        }
        this.posStateBits = pb;
    }

    public int getDictionarySize() {
        return this.dictionarySize;
    }

    public void setDictionarySize(int dictSize) {
        if (dictSize < 1 || dictSize > 0x20000000) {
            throw new IllegalArgumentException();
        }
        this.dictionarySize = dictSize;
    }

    public long getUncompressedSize() {
        return this.uncompressedSize;
    }

    public void setUncompressedSize(long uncompressedSize) {
        this.uncompressedSize = uncompressedSize;
    }

    public void fromByteBuffer(ByteBuffer propBuffer) {
        if (propBuffer.limit() != this.getPropSize()) {
            throw new IllegalArgumentException("Wrong buffer size, expected " + this.getPropSize() + " bytes");
        }
        propBuffer.rewind();
        propBuffer.order(ByteOrder.LITTLE_ENDIAN);
        if (this.isIncludeProps()) {
            byte first = propBuffer.get();
            this.setNumLiteralContextBits(first % 9);
            int remainder = first / 9;
            this.setNumLiteralPosStateBits(remainder % 5);
            this.setPosStateBits(remainder / 5);
            this.setDictionarySize(propBuffer.getInt());
        }
        if (this.isIncludeSize()) {
            this.setUncompressedSize(propBuffer.getLong());
        }
    }

    public void fromArray(byte[] properties) {
        this.fromByteBuffer(ByteBuffer.wrap(properties));
    }

    public ByteBuffer toByteBuffer() {
        ByteBuffer propBuffer = ByteBuffer.allocate(this.getPropSize());
        propBuffer.order(ByteOrder.LITTLE_ENDIAN);
        if (this.isIncludeProps()) {
            propBuffer.put((byte)((this.getPosStateBits() * 5 + this.getNumLiteralPosStateBits()) * 9 + this.getNumLiteralContextBits()));
            propBuffer.putInt(this.getDictionarySize());
        }
        if (this.isIncludeSize()) {
            propBuffer.putLong(this.getUncompressedSize());
        }
        return propBuffer;
    }

    public byte[] toArray() {
        return this.toByteBuffer().array();
    }

    public String toString() {
        return String.format("lc: %d, lp: %d, pb: %d, dictSize: %d", this.getNumLiteralContextBits(), this.getNumLiteralPosStateBits(), this.getPosStateBits(), this.getDictionarySize());
    }
}

