/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.log;

import info.ata4.log.ConsoleHandler;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class LogUtils {
    private LogUtils() {
    }

    public static Logger getLogger() {
        String className = new Throwable().getStackTrace()[1].getClassName();
        return Logger.getLogger(className);
    }

    public static void configure() {
        LogUtils.configure(Level.INFO);
    }

    public static void configure(Level level) {
        LogUtils.configure("info.ata4", level);
    }

    public static void configure(String pkg, Level level) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        ps.printf("handlers = %s\n", ConsoleHandler.class.getName());
        ps.printf(".level = %s\n", Level.INFO);
        ps.printf("%s.level = %s\n", pkg, level.getName());
        try (ByteArrayInputStream is = new ByteArrayInputStream(baos.toByteArray());){
            LogManager.getLogManager().readConfiguration(is);
        }
        catch (IOException ex) {
            System.err.println("Can't read logger configuration: " + ex);
            try {
                LogManager.getLogManager().readConfiguration();
            }
            catch (IOException ex2) {
                System.err.println("Can't restore logger configuration: " + ex2);
            }
        }
    }
}

