/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.util.gui;

import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.swing.JTextArea;

public class TextAreaHandler
extends Handler {
    private JTextArea out;
    private JTextArea err;
    private boolean doneHeader;

    public TextAreaHandler(JTextArea out, JTextArea err) {
        this.out = out;
        this.err = err;
    }

    private void doHeaders() {
        if (!this.doneHeader) {
            String head = this.getFormatter().getHead(this);
            this.out.append(head);
            this.err.append(head);
            this.doneHeader = true;
        }
    }

    @Override
    public void publish(LogRecord record) {
        String msg;
        try {
            msg = this.getFormatter().format(record);
        }
        catch (Exception ex) {
            this.reportError(null, ex, 5);
            return;
        }
        try {
            this.doHeaders();
            if (record.getLevel().intValue() >= Level.WARNING.intValue()) {
                this.err.append(msg);
            }
            this.out.append(msg);
            this.out.setCaretPosition(this.out.getDocument().getLength());
        }
        catch (Exception ex) {
            this.reportError(null, ex, 1);
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws SecurityException {
        this.doHeaders();
    }
}

