/*
 * Decompiled with CFR 0.152.
 */
package lzma;

import java.io.IOException;
import lzma.rangecoder.BitTreeEncoder;
import lzma.rangecoder.RangeEncoder;

class LenEncoder {
    private short[] _choice = new short[2];
    private BitTreeEncoder[] _lowCoder = new BitTreeEncoder[16];
    private BitTreeEncoder[] _midCoder = new BitTreeEncoder[16];
    private BitTreeEncoder _highCoder = new BitTreeEncoder(8);

    LenEncoder() {
        for (int posState = 0; posState < 16; ++posState) {
            this._lowCoder[posState] = new BitTreeEncoder(3);
            this._midCoder[posState] = new BitTreeEncoder(3);
        }
    }

    void init(int numPosStates) {
        RangeEncoder.initBitModels(this._choice);
        for (int posState = 0; posState < numPosStates; ++posState) {
            this._lowCoder[posState].init();
            this._midCoder[posState].init();
        }
        this._highCoder.init();
    }

    void encode(RangeEncoder rangeEncoder, int symbol, int posState) throws IOException {
        if (symbol < 8) {
            rangeEncoder.encode(this._choice, 0, 0);
            this._lowCoder[posState].encode(rangeEncoder, symbol);
        } else {
            rangeEncoder.encode(this._choice, 0, 1);
            if ((symbol -= 8) < 8) {
                rangeEncoder.encode(this._choice, 1, 0);
                this._midCoder[posState].encode(rangeEncoder, symbol);
            } else {
                rangeEncoder.encode(this._choice, 1, 1);
                this._highCoder.encode(rangeEncoder, symbol - 8);
            }
        }
    }

    void setPrices(int posState, int numSymbols, int[] prices, int st) {
        int a0 = RangeEncoder.getPrice0(this._choice[0]);
        int a1 = RangeEncoder.getPrice1(this._choice[0]);
        int b0 = a1 + RangeEncoder.getPrice0(this._choice[1]);
        int b1 = a1 + RangeEncoder.getPrice1(this._choice[1]);
        int i = 0;
        for (i = 0; i < 8; ++i) {
            if (i >= numSymbols) {
                return;
            }
            prices[st + i] = a0 + this._lowCoder[posState].getPrice(i);
        }
        while (i < 16) {
            if (i >= numSymbols) {
                return;
            }
            prices[st + i] = b0 + this._midCoder[posState].getPrice(i - 8);
            ++i;
        }
        while (i < numSymbols) {
            prices[st + i] = b1 + this._highCoder.getPrice(i - 8 - 8);
            ++i;
        }
    }
}

