/*
 * Decompiled with CFR 0.152.
 */
package lzma.rangecoder;

import java.io.IOException;
import java.io.InputStream;
import lzma.rangecoder.RangeCoder;

public class RangeDecoder
extends RangeCoder {
    private InputStream stream;
    private int range;
    private int code;

    public void setStream(InputStream stream) {
        this.stream = stream;
    }

    public void releaseStream() {
        this.stream = null;
    }

    public void init() throws IOException {
        this.code = 0;
        this.range = -1;
        for (int i = 0; i < 5; ++i) {
            this.code = this.code << 8 | this.stream.read();
        }
    }

    public int decodeDirectBits(int numTotalBits) throws IOException {
        int result = 0;
        for (int i = numTotalBits; i != 0; --i) {
            this.range >>>= 1;
            int t = this.code - this.range >>> 31;
            this.code -= this.range & t - 1;
            result = result << 1 | 1 - t;
            if ((this.range & 0xFF000000) != 0) continue;
            this.code = this.code << 8 | this.stream.read();
            this.range <<= 8;
        }
        return result;
    }

    public int decodeBit(short[] probs, int index) throws IOException {
        short prob = probs[index];
        int newBound = (this.range >>> 11) * prob;
        if ((this.code ^ Integer.MIN_VALUE) < (newBound ^ Integer.MIN_VALUE)) {
            this.range = newBound;
            probs[index] = (short)(prob + (2048 - prob >>> 5));
            if ((this.range & 0xFF000000) == 0) {
                this.code = this.code << 8 | this.stream.read();
                this.range <<= 8;
            }
            return 0;
        }
        this.range -= newBound;
        this.code -= newBound;
        probs[index] = (short)(prob - (prob >>> 5));
        if ((this.range & 0xFF000000) == 0) {
            this.code = this.code << 8 | this.stream.read();
            this.range <<= 8;
        }
        return 1;
    }

    public static void initBitModels(short[] probs) {
        for (int i = 0; i < probs.length; ++i) {
            probs[i] = 1024;
        }
    }
}

