/*
 * Decompiled with CFR 0.152.
 */
package lzma.rangecoder;

import java.io.IOException;
import java.io.OutputStream;
import lzma.rangecoder.RangeCoder;

public class RangeEncoder
extends RangeCoder {
    public static final int kNumBitPriceShiftBits = 6;
    private static final int kNumMoveReducingBits = 2;
    private static int[] ProbPrices = new int[512];
    private OutputStream stream;
    private long low;
    private int range;
    private int _cacheSize;
    private int _cache;
    private long _position;

    public void setStream(OutputStream stream) {
        this.stream = stream;
    }

    public void releaseStream() {
        this.stream = null;
    }

    public void init() {
        this._position = 0L;
        this.low = 0L;
        this.range = -1;
        this._cacheSize = 1;
        this._cache = 0;
    }

    public void flushData() throws IOException {
        for (int i = 0; i < 5; ++i) {
            this.shiftLow();
        }
    }

    public void flushStream() throws IOException {
        this.stream.flush();
    }

    public void shiftLow() throws IOException {
        int LowHi = (int)(this.low >>> 32);
        if (LowHi != 0 || this.low < 0xFF000000L) {
            this._position += (long)this._cacheSize;
            int temp = this._cache;
            do {
                this.stream.write(temp + LowHi);
                temp = 255;
            } while (--this._cacheSize != 0);
            this._cache = (int)this.low >>> 24;
        }
        ++this._cacheSize;
        this.low = (this.low & 0xFFFFFFL) << 8;
    }

    public void encodeDirectBits(int v, int numTotalBits) throws IOException {
        for (int i = numTotalBits - 1; i >= 0; --i) {
            this.range >>>= 1;
            if ((v >>> i & 1) == 1) {
                this.low += (long)this.range;
            }
            if ((this.range & 0xFF000000) != 0) continue;
            this.range <<= 8;
            this.shiftLow();
        }
    }

    public long getProcessedSizeAdd() {
        return (long)this._cacheSize + this._position + 4L;
    }

    public static void initBitModels(short[] probs) {
        for (int i = 0; i < probs.length; ++i) {
            probs[i] = 1024;
        }
    }

    public void encode(short[] probs, int index, int symbol) throws IOException {
        short prob = probs[index];
        int newBound = (this.range >>> 11) * prob;
        if (symbol == 0) {
            this.range = newBound;
            probs[index] = (short)(prob + (2048 - prob >>> 5));
        } else {
            this.low += (long)newBound & 0xFFFFFFFFL;
            this.range -= newBound;
            probs[index] = (short)(prob - (prob >>> 5));
        }
        if ((this.range & 0xFF000000) == 0) {
            this.range <<= 8;
            this.shiftLow();
        }
    }

    public static int getPrice(int Prob, int symbol) {
        return ProbPrices[((Prob - symbol ^ -symbol) & 0x7FF) >>> 2];
    }

    public static int getPrice0(int Prob) {
        return ProbPrices[Prob >>> 2];
    }

    public static int getPrice1(int Prob) {
        return ProbPrices[2048 - Prob >>> 2];
    }

    static {
        int kNumBits = 9;
        for (int i = kNumBits - 1; i >= 0; --i) {
            int start = 1 << kNumBits - i - 1;
            int end = 1 << kNumBits - i;
            for (int j = start; j < end; ++j) {
                RangeEncoder.ProbPrices[j] = (i << 6) + (end - j << 6 >>> kNumBits - i - 1);
            }
        }
    }
}

