/*
 * Decompiled with CFR 0.152.
 */
package net.contrapunctus.lzma;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Random;
import java.util.zip.Adler32;
import java.util.zip.Checksum;
import net.contrapunctus.lzma.LzmaInputStream;
import net.contrapunctus.lzma.LzmaOutputStream;

public class Benchmark {
    private static byte[][] data = null;
    private static final Random rnd = new Random(-889275714L);
    private static final Checksum ck = new Adler32();
    private static final int EXPONENT = 18;
    private static final int ITERATIONS = 512;
    private static final int BUFSIZE = 8192;

    public static void doit() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        LzmaOutputStream lo = new LzmaOutputStream(baos);
        int byteCount = 0;
        for (int i = 0; i < 512; ++i) {
            int k = rnd.nextInt(data.length);
            lo.write(data[k]);
            ck.update(data[k], 0, data[k].length);
            byteCount += data[k].length;
        }
        lo.close();
        byte[] buf = baos.toByteArray();
        long sum = ck.getValue();
        System.out.printf("%d bytes written, %d bytes compressed, checksum %X\n", byteCount, buf.length, sum);
        ByteArrayInputStream bais = new ByteArrayInputStream(buf);
        LzmaInputStream li = new LzmaInputStream(bais);
        buf = new byte[8192];
        ck.reset();
        int k = li.read(buf);
        byteCount = 0;
        while (k > 0) {
            byteCount += k;
            ck.update(buf, 0, k);
            k = li.read(buf);
        }
        System.out.printf("%d bytes decompressed, checksum %X\n", byteCount, ck.getValue());
        assert (sum == ck.getValue());
    }

    public static void main(String[] args) throws IOException {
        long start = System.nanoTime();
        Benchmark.doit();
        long elapsed = System.nanoTime() - start;
        System.out.printf("%d us elapsed\n", elapsed /= 1000L);
    }

    static {
        data = new byte[18][];
        int num = 1;
        int i = 0;
        while (i < data.length) {
            Benchmark.data[i] = new byte[num];
            rnd.nextBytes(data[i]);
            ++i;
            num *= 2;
        }
    }
}

