/*
 * Decompiled with CFR 0.152.
 */
package entspy;

import entspy.Entity;
import entspy.Gamelump;
import entspy.JProgFrame;
import entspy.Lump;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.CRC32;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import util.Cons;

public class BSP {
    int ident;
    int version;
    Lump[] lump;
    int maprev;
    int glumps;
    Gamelump[] glump;
    RandomAccessFile raf;
    ArrayList<Entity> el;
    Map<String, Entity> namemap;
    boolean dirty;
    CRC32 crc;
    int entlumpstart;
    int entsize;
    int entlumpsize;
    int entoriglumpsize;
    int entdiff;
    int entnewlumpstart;
    int entnewlumpsize;
    int entnewdiff;
    ArrayList<Lump> lumplist;
    int biggestgap;
    int gapoffset;
    boolean isroomingap;
    boolean isentaftergl;
    boolean isgapaftergl;
    boolean opt_preserve;
    boolean opt_optimize;
    boolean opt_insert;
    int opts;
    JProgFrame prog;
    int progress;

    public BSP(RandomAccessFile randomAccessFile) {
        this.raf = randomAccessFile;
        this.dirty = false;
    }

    public void setfile(RandomAccessFile randomAccessFile) {
        this.raf = randomAccessFile;
    }

    public void loadheader() throws IOException {
        this.raf.seek(0L);
        byte[] byArray = new byte[1036];
        this.raf.read(byArray);
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.readheader(byteBuffer);
    }

    public void readheader(ByteBuffer byteBuffer) {
        byteBuffer.position(0);
        this.ident = byteBuffer.getInt();
        int n = 1347633750;
        this.version = byteBuffer.getInt();
        Cons.println("Ident: " + this.ident);
        Cons.println("Version: " + this.version);
        if (this.ident != n || this.version != 19 && this.version != 17) {
            Cons.println("Unknown map file ident or version!");
            System.exit(1);
        }
        this.lump = new Lump[64];
        this.lumplist = new ArrayList();
        for (int i = 0; i < 64; ++i) {
            this.lump[i] = new Lump();
            this.lump[i].index = i;
            this.lump[i].ofs = byteBuffer.getInt();
            this.lump[i].len = byteBuffer.getInt();
            this.lump[i].vers = byteBuffer.getInt();
            this.lump[i].fourCC = byteBuffer.getInt();
            if (this.lump[i].len <= 0) continue;
            this.lumplist.add(this.lump[i]);
            Cons.print("" + i + ": ");
            Cons.print(this.lump[i].ofs + ", " + this.lump[i].len + ", " + this.lump[i].vers + ", " + this.lump[i].fourCC);
            Cons.print(" " + Lump.name(i) + "  " + this.lump[i].len / Lump.size(i) + (Lump.size(i) == 1 ? " bytes" : ""));
            if (this.lump[i].len % Lump.size(i) != 0) {
                Cons.println("    XXXXX");
            }
            Cons.println();
        }
        this.maprev = byteBuffer.getInt();
        Cons.println("MapRev: " + this.maprev);
        Collections.sort(this.lumplist);
    }

    public void loadentities() throws IOException {
        this.el = new ArrayList();
        this.raf.seek(this.lump[0].ofs);
        long l = this.lump[0].ofs + this.lump[0].len;
        boolean bl = false;
        boolean bl2 = false;
        this.progress = 0;
        while (!bl2) {
            long l2 = this.raf.getFilePointer();
            if (l2 >= l) {
                bl2 = true;
                break;
            }
            this.progress = (int)l2 - this.lump[0].ofs;
            String string = this.raf.readLine();
            if (string == null) {
                System.out.println("End of file");
                bl2 = true;
                break;
            }
            if (!string.equals("{")) {
                bl2 = true;
                System.out.println("End of entities");
                continue;
            }
            Entity entity = new Entity();
            while ((string = this.raf.readLine()) != null) {
                if (string.equals("}")) {
                    entity.index = this.el.size();
                    this.el.add(entity);
                    break;
                }
                String[] stringArray = string.split("\"", -1);
                if (stringArray.length == 5) {
                    String string2 = stringArray[1];
                    String string3 = stringArray[3];
                    entity.key.add(string2);
                    entity.value.add(string3);
                    entity.link.add(null);
                }
                if (!string.equals("}")) continue;
            }
            entity.setnames();
        }
        System.out.println("Size: " + this.el.size() + " entities");
    }

    public void buildlinks() {
        int n;
        Entity entity = new Entity();
        System.out.println("Building targetname map");
        int n2 = 0;
        this.namemap = new TreeMap<String, Entity>();
        for (n = 0; n < this.el.size(); ++n) {
            entity = this.el.get(n);
            if (entity.targetname == null) continue;
            this.namemap.put(entity.targetname, entity);
            ++n2;
        }
        System.out.println(n2 + " out of " + this.el.size() + " entities have targetnames");
        System.out.println("Building links");
        n = 0;
        for (int i = 0; i < this.el.size(); ++i) {
            entity = this.el.get(i);
            entity.mark = false;
            if (entity.key == null) continue;
            for (int j = 0; j < entity.key.size(); ++j) {
                if (entity.key.get(j).equals("targetname")) continue;
                String string = entity.value.get(j);
                String[] stringArray = string.split(",");
                Entity entity2 = this.namemap.get(stringArray[0]);
                if (entity2 != null) {
                    entity.link.set(j, entity2);
                    ++n;
                    continue;
                }
                entity.link.set(j, null);
            }
        }
        System.out.println(n + " links found");
    }

    public DefaultMutableTreeNode getTree() {
        int n;
        this.buildlinks();
        Entity entity = this.el.get(0);
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(entity);
        int n2 = 1;
        int n3 = 0;
        while (n2 < this.el.size() && n3 < 30) {
            ++n3;
            block1: for (n = 1; n < this.el.size(); ++n) {
                Object object;
                entity = this.el.get(n);
                if (entity.mark) continue;
                if (entity.parentname == null) {
                    object = new DefaultMutableTreeNode(entity);
                    defaultMutableTreeNode.add((MutableTreeNode)object);
                    ++n2;
                    entity.mark = true;
                    continue;
                }
                Enumeration<TreeNode> enumeration = defaultMutableTreeNode.preorderEnumeration();
                do {
                    DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
                    object = (Entity)defaultMutableTreeNode2.getUserObject();
                    if (defaultMutableTreeNode2 == defaultMutableTreeNode || ((Entity)object).targetname == null || !((Entity)object).targetname.equals(entity.parentname)) continue;
                    DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(entity);
                    defaultMutableTreeNode2.add(defaultMutableTreeNode3);
                    ++n2;
                    entity.mark = true;
                    continue block1;
                } while (enumeration.hasMoreElements());
            }
        }
        if (n2 < this.el.size()) {
            System.out.println(this.el.size() - n2 + " element(s) with unknown parent");
            for (n = 1; n < this.el.size(); ++n) {
                entity = this.el.get(n);
                if (entity.mark) continue;
                System.out.println(entity + ": no such parent " + entity.parentname);
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(entity));
            }
        }
        return defaultMutableTreeNode;
    }

    public void setprog(JProgFrame jProgFrame) {
        this.prog = jProgFrame;
    }

    public void calcentitylump() {
        int n;
        this.entlumpstart = this.lump[0].ofs;
        this.entoriglumpsize = this.roundupto4(this.lump[0].len);
        this.entsize = 1;
        for (n = 0; n < this.el.size(); ++n) {
            this.entsize += this.el.get(n).bytesize();
        }
        this.entlumpsize = this.roundupto4(this.entsize + 1);
        this.entdiff = this.entlumpsize - this.entoriglumpsize;
        this.biggestgap = 0;
        this.gapoffset = 0;
        for (n = 0; n < this.lumplist.size() - 1; ++n) {
            int n2 = this.lumplist.get((int)(n + 1)).ofs - (this.lumplist.get((int)n).ofs + this.lumplist.get((int)n).len);
            if (n2 <= 4 || n2 <= this.biggestgap) continue;
            this.gapoffset = this.roundupto4(this.lumplist.get((int)n).ofs + this.lumplist.get((int)n).len);
            this.biggestgap = this.lumplist.get((int)(n + 1)).ofs - this.gapoffset;
        }
        this.isroomingap = this.biggestgap >= this.entlumpsize;
        this.isgapaftergl = this.lump[35].ofs < this.gapoffset;
        this.isentaftergl = this.lump[35].len == 0 || this.lump[35].ofs < this.lump[0].ofs;
        this.opt_insert = false;
        this.opt_optimize = false;
        this.opt_preserve = false;
        if (this.isentaftergl) {
            if (!this.isroomingap) {
                this.opt_preserve = true;
            } else {
                this.opt_insert = true;
                this.opt_optimize = true;
            }
        } else {
            this.opt_optimize = true;
            if (!this.isroomingap) {
                this.opt_preserve = true;
                if (this.entdiff == 0) {
                    this.opt_optimize = false;
                }
            } else {
                this.opt_insert = true;
            }
        }
        this.opts = 0;
        if (this.opt_insert) {
            ++this.opts;
        }
        if (this.opt_optimize) {
            ++this.opts;
        }
        if (this.opt_preserve) {
            ++this.opts;
        }
    }

    public void saveheader(RandomAccessFile randomAccessFile, int n) throws IOException {
        this.entnewlumpstart = this.entlumpstart;
        this.entnewlumpsize = this.entsize;
        if (n == 1) {
            this.entnewlumpstart = this.roundupto4((int)this.raf.length());
        }
        if (n == 2) {
            this.entnewlumpsize = this.entoriglumpsize;
        }
        this.entnewdiff = this.entnewlumpsize - this.entoriglumpsize;
        randomAccessFile.seek(0L);
        byte[] byArray = new byte[1036];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.position(0);
        byteBuffer.putInt(this.ident);
        byteBuffer.putInt(this.version);
        for (int i = 0; i < 64; ++i) {
            Lump lump = this.lump[i];
            if (lump.ofs > this.entnewlumpstart) {
                lump.ofs += this.entnewdiff;
            }
            if (i == 0) {
                lump.len = this.entsize;
                lump.ofs = this.entnewlumpstart;
            }
            byteBuffer.putInt(lump.ofs);
            byteBuffer.putInt(lump.len);
            byteBuffer.putInt(lump.vers);
            byteBuffer.putInt(lump.fourCC);
        }
        byteBuffer.putInt(this.maprev);
        randomAccessFile.write(byArray);
    }

    public void savepre(RandomAccessFile randomAccessFile) throws IOException {
        this.raf.seek(1036L);
        this.blockcopy(this.raf, randomAccessFile, this.entlumpstart - 1036);
    }

    public void saveent(RandomAccessFile randomAccessFile) throws IOException {
        randomAccessFile.seek(this.entnewlumpstart);
        this.prog.setMaximum(this.el.size());
        for (int i = 0; i < this.el.size(); ++i) {
            Entity entity = this.el.get(i);
            randomAccessFile.writeBytes("{\n");
            for (int j = 0; j < entity.key.size(); ++j) {
                randomAccessFile.writeBytes(entity.getkeyvalstring(j) + "\n");
            }
            randomAccessFile.writeBytes("}\n");
            this.prog.setValue(i);
        }
        randomAccessFile.writeByte(0);
    }

    public void savepost(RandomAccessFile randomAccessFile, int n) throws IOException {
        long l = this.raf.length();
        this.raf.seek(this.entlumpstart + this.entoriglumpsize);
        if (n == 1) {
            randomAccessFile.seek(this.entlumpstart + this.entoriglumpsize);
        } else {
            randomAccessFile.seek(this.entlumpstart + this.entnewlumpsize);
        }
        long l2 = l - this.raf.getFilePointer();
        if (l2 > 0L) {
            this.blockcopy(this.raf, randomAccessFile, l2);
        }
    }

    public void loadglumps() throws IOException {
        this.raf.seek(this.lump[35].ofs);
        byte[] byArray = new byte[16];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.raf.read(byArray, 0, 4);
        this.glumps = byteBuffer.getInt();
        this.glump = new Gamelump[this.glumps];
        for (int i = 0; i < this.glumps; ++i) {
            this.glump[i] = new Gamelump();
            this.raf.read(byArray);
            byteBuffer.position(0);
            this.glump[i].id = byteBuffer.getInt();
            this.glump[i].flags = byteBuffer.getShort();
            this.glump[i].version = byteBuffer.getShort();
            this.glump[i].fileofs = byteBuffer.getInt();
            this.glump[i].filelen = byteBuffer.getInt();
        }
    }

    public void saveglumps(RandomAccessFile randomAccessFile) throws IOException {
        byte[] byArray = new byte[4 + 16 * this.glumps];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.putInt(this.glumps);
        for (int i = 0; i < this.glumps; ++i) {
            Gamelump gamelump = this.glump[i];
            if (gamelump.fileofs > this.entnewlumpstart) {
                gamelump.fileofs += this.entnewdiff;
            }
            byteBuffer.putInt(gamelump.id);
            byteBuffer.putShort(gamelump.flags);
            byteBuffer.putShort(gamelump.version);
            byteBuffer.putInt(gamelump.fileofs);
            byteBuffer.putInt(gamelump.filelen);
        }
        randomAccessFile.seek(this.lump[35].ofs);
        randomAccessFile.write(byArray);
    }

    public void blockcopy(RandomAccessFile randomAccessFile, RandomAccessFile randomAccessFile2, long l) throws IOException {
        byte[] byArray = new byte[10240];
        int n = (int)(l / 10240L);
        int n2 = (int)(l % 10240L);
        this.prog.setMaximum(n + 1);
        for (int i = 0; i < n; ++i) {
            randomAccessFile.read(byArray);
            randomAccessFile2.write(byArray);
            this.prog.setValue(i);
        }
        if (n2 == 0) {
            return;
        }
        randomAccessFile.read(byArray, 0, n2);
        randomAccessFile2.write(byArray, 0, n2);
        this.prog.setValue(n + 1);
    }

    public int roundupto4(int n) {
        return (n + 3) / 4 * 4;
    }

    public int loadtaskprogress() {
        return this.progress;
    }

    public int loadtasklength() {
        return this.lump[0].len;
    }

    public void computecrc() throws IOException {
        int n = 0;
        this.crc = new CRC32();
        byte[] byArray = new byte[1024];
        for (int i = 1; i < 64; ++i) {
            this.raf.seek(this.lump[i].ofs);
            for (int j = this.lump[i].len; j > 0; j -= n) {
                n = j > 1024 ? this.raf.read(byArray, 0, 1024) : this.raf.read(byArray, 0, j);
                if (n <= 0) continue;
                this.crc.update(byArray, 0, n);
            }
        }
    }
}

