/*
 * Decompiled with CFR 0.152.
 */
package entspy;

import entspy.BSP;
import entspy.EntFileFilter;
import entspy.Entity;
import entspy.JProgFrame;
import entspy.JTBEditor;
import entspy.JTBRenderer;
import entspy.KeyValLinkModel;
import entspy.MapInfo;
import entspy.TERenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreePath;
import util.Cons;
import util.SwingWorker;

public class Entspy {
    BSP m;
    String filename;
    File infile;
    RandomAccessFile raf;
    DefaultMutableTreeNode root;
    JFrame frame = null;
    final Entity blank = new Entity("");
    JTree tree;
    JTable table;
    MapInfo info;
    static final String VERSION = "v0.7";
    static ImageIcon esIcon = new ImageIcon(JTBRenderer.class.getResource("/images/entspy.gif"));

    public int exec() throws IOException {
        Cons.println("Entspy v0.7 rof@mellish.org.uk");
        this.frame = new JFrame("Entspy");
        this.frame.setIconImage(esIcon.getImage());
        if (!this.loadfile()) {
            System.exit(0);
        }
        this.m = new BSP(this.raf);
        this.m.loadheader();
        this.root = new DefaultMutableTreeNode(this.blank);
        this.tree = new JTree(new DefaultTreeModel(this.root));
        DefaultTreeSelectionModel defaultTreeSelectionModel = new DefaultTreeSelectionModel();
        defaultTreeSelectionModel.setSelectionMode(1);
        this.tree.setSelectionModel(defaultTreeSelectionModel);
        this.tree.setCellRenderer(new TERenderer());
        this.frame.setTitle("Entspy - " + this.filename);
        JMenu jMenu = new JMenu("File");
        JMenuItem jMenuItem = new JMenuItem("Load BSP");
        JMenuItem jMenuItem2 = new JMenuItem("Save BSP");
        jMenuItem.setToolTipText("Load an new map file");
        jMenuItem2.setToolTipText("Save the current map file");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(76, 2));
        jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        jMenu.add(jMenuItem);
        jMenu.add(jMenuItem2);
        jMenu.addSeparator();
        JMenuItem jMenuItem3 = new JMenuItem("Map info...");
        jMenuItem3.setToolTipText("Map header information");
        jMenuItem3.setAccelerator(KeyStroke.getKeyStroke(73, 2));
        jMenu.add(jMenuItem3);
        jMenu.addSeparator();
        JMenuItem jMenuItem4 = new JMenuItem("Quit");
        jMenuItem4.setToolTipText("Quit Entspy");
        jMenuItem4.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        jMenu.add(jMenuItem4);
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(jMenu);
        this.frame.setJMenuBar(jMenuBar);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (Entspy.this.checkchanged("Load BSP")) {
                        return;
                    }
                    if (!Entspy.this.loadfile()) {
                        return;
                    }
                    Entspy.this.m = new BSP(Entspy.this.raf);
                    Entspy.this.m.loadheader();
                    Entspy.this.loaddata();
                }
                catch (IOException iOException) {
                    Cons.println(iOException);
                }
            }
        });
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Entspy.this.frame.setCursor(Cursor.getPredefinedCursor(3));
                SwingWorker swingWorker = new SwingWorker(){

                    public Object construct() {
                        Entspy.this.savefile();
                        return null;
                    }

                    public void finished() {
                        Entspy.this.frame.setTitle("Entspy - " + Entspy.this.filename);
                        Entspy.this.frame.setCursor(null);
                    }
                };
                swingWorker.start();
            }
        });
        jMenuItem4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (Entspy.this.checkchanged("Quit Entspy")) {
                    return;
                }
                System.exit(0);
            }
        });
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Entspy.this.m.setfile(Entspy.this.raf);
                if (Entspy.this.info != null) {
                    Entspy.this.info.dispose();
                }
                Entspy.this.info = new MapInfo(Entspy.this.frame, Entspy.this.m, Entspy.this.filename);
            }
        });
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(4, 2));
        final JTextField jTextField = new JTextField(" ");
        final JTextField jTextField2 = new JTextField(" ");
        final JTextField jTextField3 = new JTextField(" ");
        final JTextField jTextField4 = new JTextField(" ");
        jTextField.addActionListener(new TextListen(0));
        jTextField2.addActionListener(new TextListen(1));
        jTextField3.addActionListener(new TextListen(2));
        jTextField4.addActionListener(new TextListen(3));
        jTextField.setEnabled(false);
        jTextField2.setEnabled(false);
        jTextField3.setEnabled(false);
        jTextField4.setEnabled(false);
        jPanel2.add(new JLabel(" Classname ", 4));
        jPanel2.add(jTextField);
        jPanel2.add(new JLabel(" Targetname ", 4));
        jPanel2.add(jTextField2);
        jPanel2.add(new JLabel(" Parentname ", 4));
        jPanel2.add(jTextField3);
        jPanel2.add(new JLabel(" Origin ", 4));
        jPanel2.add(jTextField4);
        jPanel.add((Component)jPanel2, "North");
        JPanel jPanel3 = new JPanel();
        final KeyValLinkModel keyValLinkModel = new KeyValLinkModel();
        keyValLinkModel.setTreeMapping(this.tree);
        this.table = new JTable(keyValLinkModel);
        this.table.setSelectionMode(0);
        TableColumn tableColumn = this.table.getColumn("Value");
        tableColumn.setPreferredWidth(175);
        TableColumn tableColumn2 = this.table.getColumn("Link");
        tableColumn2.setMaxWidth(30);
        tableColumn2.setMinWidth(30);
        tableColumn2.setResizable(false);
        tableColumn2.setCellRenderer(new JTBRenderer());
        tableColumn2.setCellEditor(new JTBEditor(new JCheckBox()));
        jPanel3.setLayout(new GridLayout(1, 1));
        jPanel3.add(new JScrollPane(this.table));
        jPanel.add((Component)jPanel3, "Center");
        JPanel jPanel4 = new JPanel();
        final JLabel jLabel = new JLabel("Linked from ");
        jPanel4.add(jLabel);
        final DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        final JComboBox jComboBox = new JComboBox(defaultComboBoxModel);
        jComboBox.setPreferredSize(new Dimension(200, jComboBox.getPreferredSize().height));
        Font font = jComboBox.getFont();
        jComboBox.setFont(new Font(font.getName(), 0, font.getSize() - 1));
        jComboBox.setToolTipText("Entity that links to this entity");
        jPanel4.add(jComboBox);
        final JTBRenderer jTBRenderer = new JTBRenderer();
        jTBRenderer.setToolTipText("Go to linking entity");
        jTBRenderer.setMnemonic(76);
        jPanel4.add(jTBRenderer);
        jTBRenderer.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Entity entity = (Entity)defaultComboBoxModel.getSelectedItem();
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)Entspy.this.tree.getModel().getRoot();
                do {
                    if (Entspy.this.getNodeEntity(defaultMutableTreeNode) != entity) continue;
                    TreePath treePath = new TreePath(defaultMutableTreeNode.getPath());
                    Entspy.this.tree.setSelectionPath(treePath);
                    Entspy.this.tree.scrollPathToVisible(treePath);
                    return;
                } while ((defaultMutableTreeNode = defaultMutableTreeNode.getNextNode()) != null);
                Cons.println("Cannot find node for target ent: " + entity);
            }
        });
        jLabel.setEnabled(false);
        jTBRenderer.setEnabled(false);
        jComboBox.setEnabled(false);
        jPanel.add((Component)jPanel4, "South");
        JPanel jPanel5 = new JPanel(new BorderLayout());
        jPanel5.add((Component)new JScrollPane(this.tree), "Center");
        JPanel jPanel6 = new JPanel(new BorderLayout());
        JPanel jPanel7 = new JPanel();
        JButton jButton = new JButton("Update");
        jButton.setToolTipText("Update entity links");
        jButton.setMnemonic(85);
        JButton jButton2 = new JButton("Add");
        jButton2.setToolTipText("Add a new entity");
        jButton2.setMnemonic(155);
        final JButton jButton3 = new JButton("Copy");
        jButton3.setToolTipText("Copy the selected entity");
        jButton3.setEnabled(false);
        jButton3.setMnemonic(10);
        final JButton jButton4 = new JButton("Del");
        jButton4.setToolTipText("Delete the selected entity");
        jButton4.setEnabled(false);
        jButton4.setMnemonic(127);
        jPanel7.add(jButton);
        jPanel7.add(jButton2);
        jPanel7.add(jButton3);
        jPanel7.add(jButton4);
        jPanel6.add((Component)jPanel7, "South");
        JButton jButton5 = new JButton("Find");
        jButton5.setToolTipText("Find entity");
        jButton5.setMnemonic(114);
        JTextField jTextField5 = new JTextField();
        jTextField5.setToolTipText("Text to search for");
        Box box = Box.createHorizontalBox();
        box.add(jTextField5);
        box.add(jButton5);
        jPanel6.add((Component)box, "Center");
        jPanel6.setBorder(BorderFactory.createEtchedBorder());
        jPanel5.add((Component)jPanel6, "South");
        jButton5.addActionListener(new FindListen(jTextField5));
        jTextField5.addActionListener(new FindListen(jTextField5));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Entspy.this.root = Entspy.this.m.getTree();
                Entspy.this.tree.setModel(new DefaultTreeModel(Entspy.this.root));
            }
        });
        jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Entity entity = Entspy.this.getSelectedEntity();
                int n = Entspy.this.m.el.indexOf(entity);
                Entspy.this.m.el.remove(n);
                Entspy.this.root = Entspy.this.m.getTree();
                Entspy.this.tree.setModel(new DefaultTreeModel(Entspy.this.root));
                Entspy.this.m.dirty = true;
            }
        });
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Entity entity = Entspy.this.getSelectedEntity();
                Entity entity2 = entity.copy();
                int n = Entspy.this.m.el.indexOf(entity);
                Entspy.this.m.el.add(n + 1, entity2);
                Entspy.this.root = Entspy.this.m.getTree();
                Entspy.this.tree.setModel(new DefaultTreeModel(Entspy.this.root));
                DefaultMutableTreeNode defaultMutableTreeNode = Entspy.this.root;
                do {
                    if (Entspy.this.getNodeEntity(defaultMutableTreeNode) != entity2) continue;
                    TreePath treePath = new TreePath(defaultMutableTreeNode.getPath());
                    Entspy.this.tree.setSelectionPath(treePath);
                    Entspy.this.tree.scrollPathToVisible(treePath);
                    break;
                } while ((defaultMutableTreeNode = defaultMutableTreeNode.getNextNode()) != null);
                Entspy.this.m.dirty = true;
            }
        });
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object object;
                Entity entity = new Entity();
                if (Entspy.this.tree.getSelectionCount() == 0) {
                    Entspy.this.m.el.add(entity);
                } else {
                    object = Entspy.this.getSelectedEntity();
                    int n = Entspy.this.m.el.indexOf(object);
                    Entspy.this.m.el.add(n + 1, entity);
                }
                entity.autoedit = true;
                Entspy.this.root = Entspy.this.m.getTree();
                Entspy.this.tree.setModel(new DefaultTreeModel(Entspy.this.root));
                object = Entspy.this.root;
                do {
                    if (Entspy.this.getNodeEntity((DefaultMutableTreeNode)object) != entity) continue;
                    TreePath treePath = new TreePath(((DefaultMutableTreeNode)object).getPath());
                    Entspy.this.tree.setSelectionPath(treePath);
                    Entspy.this.tree.scrollPathToVisible(treePath);
                    break;
                } while ((object = ((DefaultMutableTreeNode)object).getNextNode()) != null);
                Entspy.this.m.dirty = true;
            }
        });
        JPanel jPanel8 = new JPanel();
        final JButton jButton6 = new JButton("Add");
        jButton6.setToolTipText("Add an entity property");
        jButton6.setMnemonic(65);
        jPanel8.add(jButton6);
        jButton6.setEnabled(false);
        final JButton jButton7 = new JButton("Copy");
        jButton7.setToolTipText("Copy the selected property");
        jButton7.setMnemonic(67);
        jPanel8.add(jButton7);
        jButton7.setEnabled(false);
        final JButton jButton8 = new JButton("Delete");
        jButton8.setToolTipText("Delete the selected property");
        jButton8.setMnemonic(68);
        jPanel8.add(jButton8);
        jButton8.setEnabled(false);
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                Object object;
                block8: {
                    try {
                        object = Entspy.this.table.getCellEditor();
                        if (object == null || !Entspy.this.table.isEditing()) break block8;
                        object.stopCellEditing();
                    }
                    catch (Exception exception) {
                        Cons.println(exception);
                        for (int i = 0; i < 10; ++i) {
                            Cons.println(exception.getStackTrace()[i]);
                        }
                    }
                }
                object = new Entity();
                TreePath treePath = treeSelectionEvent.getNewLeadSelectionPath();
                if (treePath != null) {
                    DefaultMutableTreeNode defaultMutableTreeNode = Entspy.this.getSelectedNode();
                    object = Entspy.this.getSelectedEntity();
                    jTextField.setText(((Entity)object).classname);
                    jTextField.setEnabled(true);
                    jTextField2.setText(((Entity)object).targetname);
                    jTextField2.setEnabled(true);
                    jTextField3.setText(((Entity)object).parentname);
                    jTextField3.setEnabled(true);
                    jTextField4.setText(((Entity)object).origin);
                    jTextField4.setEnabled(true);
                    Entspy.this.settable((Entity)object, keyValLinkModel);
                    jButton4.setEnabled(defaultMutableTreeNode != Entspy.this.root);
                    jButton3.setEnabled(true);
                    jButton6.setEnabled(true);
                    if (((Entity)object).autoedit) {
                        ((Entity)object).autoedit = false;
                        jTextField.setText("new_entity");
                        jTextField.selectAll();
                        jTextField.requestFocus();
                    }
                    if (Entspy.this.setfindlist((Entity)object, defaultComboBoxModel)) {
                        jLabel.setEnabled(true);
                        jTBRenderer.setEnabled(true);
                        jComboBox.setEnabled(true);
                    } else {
                        jLabel.setEnabled(false);
                        jTBRenderer.setEnabled(false);
                        jComboBox.setEnabled(false);
                    }
                } else {
                    jTextField.setText(" ");
                    jTextField.setEnabled(false);
                    jTextField2.setText(" ");
                    jTextField2.setEnabled(false);
                    jTextField3.setText(" ");
                    jTextField3.setEnabled(false);
                    jTextField4.setText(" ");
                    jTextField4.setEnabled(false);
                    Entspy.this.settable(Entspy.this.blank, keyValLinkModel);
                    jLabel.setEnabled(false);
                    jTBRenderer.setEnabled(false);
                    jComboBox.setEnabled(false);
                    jButton4.setEnabled(false);
                    jButton3.setEnabled(false);
                    jButton6.setEnabled(false);
                }
            }
        });
        jButton6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Entity entity = Entspy.this.getSelectedEntity();
                entity.addkeyval("", "");
                Entspy.this.settable(entity, keyValLinkModel);
                int n = entity.size() - 1;
                Entspy.this.table.changeSelection(n, 0, false, false);
                Entspy.this.table.editCellAt(n, 0);
                Entspy.this.table.scrollRectToVisible(Entspy.this.table.getCellRect(n, 0, true));
                Entspy.this.table.getEditorComponent().requestFocus();
                Entspy.this.m.dirty = true;
            }
        });
        jButton7.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Entity entity = Entspy.this.getSelectedEntity();
                int n = Entspy.this.table.getSelectedRow();
                if (n == -1) {
                    return;
                }
                entity.addkeyval(entity.key.get(n), entity.value.get(n));
                entity.setnames();
                Entspy.this.settable(entity, keyValLinkModel);
                keyValLinkModel.reselect();
                int n2 = entity.size() - 1;
                Entspy.this.table.changeSelection(n2, 1, false, false);
                Entspy.this.table.editCellAt(n2, 1);
                Entspy.this.table.scrollRectToVisible(Entspy.this.table.getCellRect(n2, 1, true));
                Entspy.this.table.getEditorComponent().requestFocus();
                Entspy.this.m.dirty = true;
            }
        });
        jButton8.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Entity entity = Entspy.this.getSelectedEntity();
                int n = Entspy.this.table.getSelectedRow();
                if (n == -1) {
                    return;
                }
                entity.delkeyval(n);
                entity.setnames();
                keyValLinkModel.fireTableDataChanged();
                keyValLinkModel.reselect();
                Entspy.this.m.dirty = true;
            }
        });
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                if (Entspy.this.table.getSelectedRowCount() != 0) {
                    jButton8.setEnabled(true);
                    jButton7.setEnabled(true);
                } else {
                    jButton8.setEnabled(false);
                    jButton7.setEnabled(false);
                }
            }
        });
        JPanel jPanel9 = new JPanel(new BorderLayout());
        jPanel9.add((Component)jPanel, "Center");
        jPanel9.add((Component)jPanel8, "South");
        jPanel8.setBorder(BorderFactory.createEtchedBorder());
        JSplitPane jSplitPane = new JSplitPane(1, jPanel5, jPanel9);
        jSplitPane.setDividerLocation(275);
        this.frame.setDefaultCloseOperation(3);
        this.frame.setSize(720, 520);
        this.frame.getContentPane().add(jSplitPane);
        this.frame.setVisible(true);
        this.loaddata();
        return 0;
    }

    public void settable(Entity entity, KeyValLinkModel keyValLinkModel) {
        keyValLinkModel.set(entity);
    }

    public boolean setfindlist(Entity entity, DefaultComboBoxModel defaultComboBoxModel) {
        defaultComboBoxModel.removeAllElements();
        block0: for (int i = 0; i < this.m.el.size(); ++i) {
            Entity entity2 = this.m.el.get(i);
            if (entity2.key == null) continue;
            for (int j = 0; j < entity2.key.size(); ++j) {
                Entity entity3 = entity2.link.get(j);
                if (entity3 == null || !entity3.targetname.equals(entity.targetname)) continue;
                defaultComboBoxModel.addElement(entity2);
                continue block0;
            }
        }
        return defaultComboBoxModel.getSize() != 0;
    }

    public int ubyte(byte by) {
        return by & 0xFF;
    }

    public boolean loadfile() {
        try {
            JFileChooser jFileChooser = new JFileChooser(System.getProperty("user.dir"));
            jFileChooser.setDialogTitle("Entspy - Open a BSP file");
            jFileChooser.setFileFilter(new EntFileFilter());
            int n = jFileChooser.showOpenDialog(this.frame);
            if (n == 1) {
                return false;
            }
            this.infile = jFileChooser.getSelectedFile();
            jFileChooser = null;
            this.filename = this.infile.getName();
            if (!this.infile.exists() || !this.infile.canRead()) {
                Cons.println("Can't read " + this.filename + "!");
                return false;
            }
            Cons.println("Reading map file " + this.filename);
            this.raf = new RandomAccessFile(this.infile, "r");
            return true;
        }
        catch (IOException iOException) {
            Cons.println(iOException);
            return false;
        }
    }

    public void savefile() {
        try {
            int n;
            JRadioButton jRadioButton;
            Serializable serializable;
            Object object;
            this.m.calcentitylump();
            int n2 = 0;
            if (this.m.entdiff > 0 && !this.m.isentaftergl) {
                object = new Object[3];
                object[0] = "Entity lump exceeds previously stored size by " + this.strsize(this.m.entdiff) + ".\nChoose an option:";
                serializable = new ButtonGroup();
                jRadioButton = new JRadioButton("Optimize storage (minimum file size, breaks checksum).", true);
                ((ButtonGroup)serializable).add(jRadioButton);
                jRadioButton.setActionCommand("Optimize");
                object[1] = jRadioButton;
                jRadioButton = new JRadioButton("Store at end (wastes " + this.strsize(this.m.entlumpsize) + ", preserves checksum).");
                ((ButtonGroup)serializable).add(jRadioButton);
                jRadioButton.setActionCommand("Preserve");
                object[2] = jRadioButton;
                n = JOptionPane.showOptionDialog(this.frame, object, "Save BSP file", 2, 3, null, null, null);
                if (n == 2) {
                    return;
                }
                if (((ButtonGroup)serializable).getSelection().getActionCommand().equals("Preserve")) {
                    n2 = 1;
                }
            }
            if (this.m.entdiff < 0 && !this.m.isentaftergl) {
                object = new Object[3];
                object[0] = "Entity lump is smaller than previously stored size by " + this.strsize(-this.m.entdiff) + ".\nChoose an option:";
                serializable = new ButtonGroup();
                jRadioButton = new JRadioButton("Optimize storage (minimum file size, breaks checksum).", true);
                ((ButtonGroup)serializable).add(jRadioButton);
                jRadioButton.setActionCommand("Optimize");
                object[1] = jRadioButton;
                jRadioButton = new JRadioButton("Store without optimization (wastes " + this.strsize(-this.m.entdiff) + ", preserves checksum).");
                ((ButtonGroup)serializable).add(jRadioButton);
                jRadioButton.setActionCommand("Preserve2");
                object[2] = jRadioButton;
                n = JOptionPane.showOptionDialog(this.frame, object, "Save BSP file", 2, 3, null, null, null);
                if (n == 2) {
                    return;
                }
                if (((ButtonGroup)serializable).getSelection().getActionCommand().equals("Preserve2")) {
                    n2 = 2;
                }
            }
            object = new JProgFrame((Component)this.frame, "Entspy - Save BSP file");
            this.m.setprog((JProgFrame)object);
            serializable = new JFileChooser(this.infile);
            ((JFileChooser)serializable).setSelectedFile(this.infile);
            ((JFileChooser)serializable).setDialogTitle("Entspy - Save BSP file - " + this.filename);
            ((JFileChooser)serializable).setFileFilter(new EntFileFilter());
            int n3 = ((JFileChooser)serializable).showSaveDialog(this.frame);
            if (n3 == 1) {
                return;
            }
            File file = ((JFileChooser)serializable).getSelectedFile();
            serializable = null;
            String string = file.getName();
            if (file.exists()) {
                n3 = JOptionPane.showConfirmDialog(this.frame, "Map file " + file + " exists.\nAre you sure you want to overwrite?", "Save BSP file", 0);
                if (n3 == 1) {
                    return;
                }
                if (this.infile.getCanonicalPath().equals(file.getCanonicalPath())) {
                    long l = this.infile.length();
                    File file2 = new File(this.infile.getAbsolutePath() + ".bak");
                    Cons.print("Copying current map file to " + file2.getAbsolutePath() + "...");
                    ((JProgFrame)object).start("Copying current map", true);
                    RandomAccessFile randomAccessFile = new RandomAccessFile(file2, "rw");
                    randomAccessFile.setLength(0L);
                    this.raf.seek(0L);
                    this.m.blockcopy(this.raf, randomAccessFile, l);
                    randomAccessFile.close();
                    Cons.println("Done");
                    this.infile = file2;
                    if (!this.infile.exists()) {
                        Cons.println("Cannot find renamed file - map save aborted");
                        this.frame.setVisible(false);
                        return;
                    }
                    this.raf.close();
                    this.raf = new RandomAccessFile(this.infile, "r");
                }
            }
            Cons.print("Writing " + string + "...");
            this.raf.seek(0L);
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
            ((JProgFrame)object).start("Saving map...", true);
            randomAccessFile.setLength(0L);
            this.m.setfile(this.raf);
            Cons.print("BSP header... ");
            this.m.saveheader(randomAccessFile, n2);
            Cons.print("Pre-entity data... ");
            ((JProgFrame)object).setString("Writing pre-entity data...");
            this.m.savepre(randomAccessFile);
            Cons.print("Entity data... ");
            ((JProgFrame)object).setString("Writing entity data...");
            this.m.saveent(randomAccessFile);
            Cons.print("Post-entity data... ");
            ((JProgFrame)object).setString("Writing post-entity data...");
            this.m.savepost(randomAccessFile, n2);
            this.m.saveglumps(randomAccessFile);
            randomAccessFile.close();
            Cons.println("Done");
            this.raf.close();
            this.infile = file;
            this.raf = new RandomAccessFile(this.infile, "r");
            this.filename = this.infile.getName();
            ((JProgFrame)object).end();
            this.m.setfile(this.raf);
            this.m.dirty = false;
        }
        catch (IOException iOException) {
            Cons.println(iOException);
        }
    }

    public void loaddata() {
        final JProgFrame jProgFrame = new JProgFrame((Component)this.frame, "Entspy - Load BSP file");
        this.m.setprog(jProgFrame);
        jProgFrame.setMaximum(this.m.loadtasklength());
        jProgFrame.start("Loading entities...", true);
        this.frame.setCursor(Cursor.getPredefinedCursor(3));
        final Timer timer = new Timer(100, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jProgFrame.setValue(Entspy.this.m.loadtaskprogress());
            }
        });
        SwingWorker swingWorker = new SwingWorker(){

            public Object construct() {
                try {
                    Entspy.this.m.loadentities();
                    Entspy.this.m.loadglumps();
                }
                catch (IOException iOException) {
                    Cons.println(iOException);
                }
                return null;
            }

            public void finished() {
                timer.stop();
                Entspy.this.root = Entspy.this.m.getTree();
                Entspy.this.tree.setModel(new DefaultTreeModel(Entspy.this.root));
                Entspy.this.frame.setCursor(null);
                jProgFrame.end();
                Entspy.this.frame.setTitle("Entspy - " + Entspy.this.filename);
            }
        };
        timer.start();
        swingWorker.start();
    }

    public boolean checkchanged(String string) {
        if (!this.m.dirty) {
            return false;
        }
        int n = JOptionPane.showConfirmDialog(this.frame, new Object[]{"File " + this.filename + " has been edited.", "Discard changes?"}, string, 0);
        return n != 0;
    }

    public String strsize(int n) {
        if (n < 2000) {
            return n + " bytes";
        }
        return new DecimalFormat("0.0").format((float)n / 1024.0f) + " kbytes";
    }

    public DefaultMutableTreeNode getSelectedNode() {
        return (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
    }

    public Entity getNodeEntity(DefaultMutableTreeNode defaultMutableTreeNode) {
        return (Entity)defaultMutableTreeNode.getUserObject();
    }

    public Entity getSelectedEntity() {
        DefaultMutableTreeNode defaultMutableTreeNode = this.getSelectedNode();
        if (defaultMutableTreeNode == null) {
            return null;
        }
        return this.getNodeEntity(defaultMutableTreeNode);
    }

    public static void main(String[] stringArray) throws Exception {
        Entspy entspy = new Entspy();
        entspy.exec();
    }

    class FindListen
    implements ActionListener {
        JTextField textf;

        public FindListen(JTextField jTextField) {
            this.textf = jTextField;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = false;
            String string = this.textf.getText();
            if (string.equals("")) {
                return;
            }
            DefaultMutableTreeNode defaultMutableTreeNode = Entspy.this.getSelectedNode();
            if (defaultMutableTreeNode == null) {
                defaultMutableTreeNode = Entspy.this.root;
            }
            DefaultMutableTreeNode defaultMutableTreeNode2 = defaultMutableTreeNode;
            for (defaultMutableTreeNode = defaultMutableTreeNode.getNextNode(); defaultMutableTreeNode != null; defaultMutableTreeNode = defaultMutableTreeNode.getNextNode()) {
                if (!Entspy.this.getNodeEntity(defaultMutableTreeNode).ismatch(string)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                for (defaultMutableTreeNode = Entspy.this.root; defaultMutableTreeNode != defaultMutableTreeNode2 && !Entspy.this.getNodeEntity(defaultMutableTreeNode).ismatch(string); defaultMutableTreeNode = defaultMutableTreeNode.getNextNode()) {
                }
            }
            TreePath treePath = new TreePath(defaultMutableTreeNode.getPath());
            Entspy.this.tree.setSelectionPath(treePath);
            Entspy.this.tree.scrollPathToVisible(treePath);
        }
    }

    class TextListen
    implements ActionListener {
        int type;

        public TextListen(int n) {
            this.type = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = ((JTextField)actionEvent.getSource()).getText().trim();
            Entity entity = Entspy.this.getSelectedEntity();
            if (entity == null) {
                return;
            }
            entity.setDefinedValue(this.type, string);
            ((KeyValLinkModel)Entspy.this.table.getModel()).refreshtable();
        }
    }
}

