/*
 * Decompiled with CFR 0.152.
 */
package entspy;

import entspy.Entity;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JTree;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

class KeyValLinkModel
extends AbstractTableModel {
    Entity ent;
    ArrayList<JButton> button;
    JTree tree;

    KeyValLinkModel() {
    }

    public void setTreeMapping(JTree jTree) {
        this.tree = jTree;
    }

    public int getRowCount() {
        if (this.ent == null) {
            return 0;
        }
        if (this.ent.key == null) {
            return 0;
        }
        return this.ent.key.size();
    }

    public int getColumnCount() {
        return 3;
    }

    public Object getValueAt(int n, int n2) {
        int n3 = n;
        if (n2 == 0) {
            return this.ent.key.get(n);
        }
        if (n2 == 1) {
            return this.ent.value.get(n);
        }
        return this.button.get(n);
    }

    public void setValueAt(Object object, int n, int n2) {
        if (n < 0 || n >= this.ent.size()) {
            return;
        }
        if (n2 == 0) {
            this.ent.key.set(n, (String)object);
        } else if (n2 == 1) {
            this.ent.value.set(n, (String)object);
        } else {
            return;
        }
        this.ent.setnames();
        this.fireTableDataChanged();
        this.reselect();
    }

    public Class getColumnClass(int n) {
        if (n == 2) {
            return JButton.class;
        }
        return String.class;
    }

    public String getColumnName(int n) {
        String[] stringArray = new String[]{"Key", "Value", "Link"};
        return stringArray[n];
    }

    public void clear() {
        this.ent = null;
        this.button.clear();
        this.fireTableDataChanged();
    }

    public boolean isCellEditable(int n, int n2) {
        return n2 != 2 || this.ent.link.get(n) != null;
    }

    public void set(Entity entity) {
        this.ent = entity;
        this.setlinklisteners();
    }

    public void setlinklisteners() {
        this.button = new ArrayList();
        for (int i = 0; i < this.ent.key.size(); ++i) {
            final int n = i;
            if (this.ent.link.get(i) != null) {
                JButton jButton = new JButton();
                jButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        Entity entity = KeyValLinkModel.this.ent.link.get(n);
                        Object[] objectArray = KeyValLinkModel.this.findtreenode(entity, KeyValLinkModel.this.tree);
                        if (objectArray != null) {
                            TreePath treePath = new TreePath(objectArray);
                            KeyValLinkModel.this.tree.setSelectionPath(treePath);
                            KeyValLinkModel.this.tree.scrollPathToVisible(treePath);
                            return;
                        }
                        System.out.println("Cannot find node for target ent: " + entity);
                    }
                });
                this.button.add(jButton);
                continue;
            }
            this.button.add(null);
        }
        this.fireTableDataChanged();
    }

    public Entity getLink(int n) {
        return this.ent.link.get(n);
    }

    public TreeNode[] findtreenode(Object object, JTree jTree) {
        TreeModel treeModel = this.tree.getModel();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treeModel.getRoot();
        do {
            if (defaultMutableTreeNode.getUserObject() != object) continue;
            return defaultMutableTreeNode.getPath();
        } while ((defaultMutableTreeNode = defaultMutableTreeNode.getNextNode()) != null);
        return null;
    }

    public void reselect() {
        TreePath treePath = this.tree.getSelectionPath();
        if (treePath != null) {
            ((DefaultTreeModel)this.tree.getModel()).nodeChanged((DefaultMutableTreeNode)treePath.getLastPathComponent());
            this.tree.clearSelection();
            this.tree.setSelectionPath(treePath);
        }
    }

    public void refreshtable() {
        this.setlinklisteners();
        this.reselect();
    }
}

