/*
 * Decompiled with CFR 0.152.
 */
package entspy;

import entspy.BSP;
import entspy.Lumpentry;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.table.AbstractTableModel;

class Lumpdata
extends AbstractTableModel {
    static String[] header = new String[]{"No.", "Lump", "Offset", "Length"};
    BSP m;
    Object[][] data;

    public Lumpdata(BSP bSP) {
        this.m = bSP;
        this.getData();
    }

    public int getRowCount() {
        return this.data.length;
    }

    public int getColumnCount() {
        return this.data[0].length;
    }

    public String getColumnName(int n) {
        return header[n];
    }

    public Object getValueAt(int n, int n2) {
        return this.data[n][n2];
    }

    public void getData() {
        int n;
        int n2;
        ArrayList<Lumpentry> arrayList = new ArrayList<Lumpentry>();
        arrayList.add(new Lumpentry("", "Header", 0, 1036));
        for (int i = 0; i < 64; ++i) {
            if (this.m.lump[i].len <= 0) continue;
            Lumpentry lumpentry = new Lumpentry(this.m.lump[i]);
            arrayList.add(lumpentry);
        }
        Collections.sort(arrayList);
        ArrayList<Lumpentry> arrayList2 = new ArrayList<Lumpentry>();
        for (n2 = 0; n2 < arrayList.size() - 1; ++n2) {
            n = ((Lumpentry)arrayList.get((int)(n2 + 1))).offset - (((Lumpentry)arrayList.get((int)n2)).offset + ((Lumpentry)arrayList.get((int)n2)).length);
            if (n <= 4) continue;
            arrayList2.add(new Lumpentry("*", "Gap", ((Lumpentry)arrayList.get((int)n2)).offset + ((Lumpentry)arrayList.get((int)n2)).length, n));
        }
        arrayList.addAll(arrayList2);
        Collections.sort(arrayList);
        this.data = new Object[arrayList.size()][4];
        n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            Lumpentry lumpentry = (Lumpentry)arrayList.get(n);
            this.data[n][0] = lumpentry.id;
            this.data[n][1] = lumpentry.name;
            this.data[n][2] = lumpentry.offset;
            this.data[n][3] = lumpentry.length;
        }
    }

    public String strint(int n) {
        char[] cArray = new char[]{(char)(n & 0xFF), (char)(n >> 8 & 0xFF), (char)(n >> 16 & 0xFF), (char)(n >>> 24 & 0xFF)};
        return new String(cArray);
    }
}

