/*
 * Decompiled with CFR 0.152.
 */
package util;

public class Vec {
    public float x;
    public float y;
    public float z;

    public Vec() {
        this(0.0f, 0.0f, 0.0f);
    }

    public Vec(Vec vec) {
        this(vec.x, vec.y, vec.z);
    }

    public Vec(float f, float f2, float f3) {
        this.x = f;
        this.y = f2;
        this.z = f3;
    }

    public Vec(String string) {
        string = string.trim();
        String[] stringArray = string.split(" ");
        this.x = Float.parseFloat(stringArray[0]);
        this.y = Float.parseFloat(stringArray[1]);
        this.z = Float.parseFloat(stringArray[2]);
    }

    public float dot(Vec vec) {
        return this.x * vec.x + this.y * vec.y + this.z * vec.z;
    }

    public Vec cross(Vec vec) {
        Vec vec2 = new Vec();
        vec2.x = this.y * vec.z - this.z * vec.y;
        vec2.y = this.z * vec.x - this.x * vec.z;
        vec2.z = this.x * vec.y - this.y * vec.x;
        return vec2;
    }

    public Vec norm() {
        Vec vec = new Vec();
        float f = this.modulus();
        vec.x = this.x / f;
        vec.y = this.y / f;
        vec.z = this.z / f;
        return vec;
    }

    public Vec add(Vec vec) {
        Vec vec2 = new Vec();
        vec2.x = this.x + vec.x;
        vec2.y = this.y + vec.y;
        vec2.z = this.z + vec.z;
        return vec2;
    }

    public Vec subtract(Vec vec) {
        Vec vec2 = new Vec();
        vec2.x = this.x - vec.x;
        vec2.y = this.y - vec.y;
        vec2.z = this.z - vec.z;
        return vec2;
    }

    public void snap(float f) {
        this.x = (float)Math.round(this.x / f) * f;
        this.y = (float)Math.round(this.y / f) * f;
        this.z = (float)Math.round(this.z / f) * f;
    }

    public boolean notvalid() {
        return Float.isNaN(this.x) || Float.isNaN(this.y) || Float.isNaN(this.z);
    }

    public float modulus() {
        return (float)Math.sqrt(Math.pow(this.x, 2.0) + Math.pow(this.y, 2.0) + Math.pow(this.z, 2.0));
    }

    public Vec scalar(float f) {
        Vec vec = new Vec();
        vec.x = this.x * f;
        vec.y = this.y * f;
        vec.z = this.z * f;
        return vec;
    }

    public float comp(int n) {
        switch (n) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
        }
        return 0.0f;
    }

    public void setcomp(int n, float f) {
        switch (n) {
            case 0: {
                this.x = f;
                break;
            }
            case 1: {
                this.y = f;
                break;
            }
            case 2: {
                this.z = f;
            }
        }
    }

    public Vec addmult(float f, Vec vec) {
        Vec vec2 = new Vec();
        vec2.x = this.x + f * vec.x;
        vec2.y = this.y + f * vec.y;
        vec2.z = this.z + f * vec.z;
        return vec2;
    }

    public Vec minbound(Vec vec) {
        Vec vec2 = new Vec(vec);
        if (this.x < vec.x) {
            vec2.x = this.x;
        }
        if (this.y < vec.y) {
            vec2.y = this.y;
        }
        if (this.z < vec.z) {
            vec2.z = this.z;
        }
        return vec2;
    }

    public Vec maxbound(Vec vec) {
        Vec vec2 = new Vec(vec);
        if (this.x > vec.x) {
            vec2.x = this.x;
        }
        if (this.y > vec.y) {
            vec2.y = this.y;
        }
        if (this.z > vec.z) {
            vec2.z = this.z;
        }
        return vec2;
    }

    public String toString() {
        return "(" + this.x + "," + this.y + "," + this.z + ")";
    }

    public Vec copy() {
        Vec vec = new Vec();
        vec.x = this.x;
        vec.y = this.y;
        vec.z = this.z;
        return vec;
    }
}

