/*
 * Decompiled with CFR 0.152.
 */
package pak;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;

public class Phymdl {
    boolean isValid = false;
    int version;
    int id;
    int numsolids;
    int checksum;
    String physblock;
    ArrayList<String> gibmodel;

    public void load(String filename) throws IOException {
        File infile = new File(filename);
        if (!infile.exists() || !infile.canRead()) {
            System.out.println("Can't open " + filename);
            return;
        }
        System.out.println("Reading " + filename);
        FileChannel rafch = new RandomAccessFile(infile, "r").getChannel();
        MappedByteBuffer mbuffer = rafch.map(FileChannel.MapMode.READ_ONLY, 0L, rafch.size());
        ByteBuffer b = mbuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.read(b);
        rafch.close();
    }

    public void read(ByteBuffer b) throws IOException {
        this.isValid = false;
        int start = b.position();
        this.version = b.getInt();
        this.id = b.getInt();
        if (this.version != 16 || this.id != 0) {
            return;
        }
        this.numsolids = b.getInt();
        this.checksum = b.getInt();
        for (int i = 0; i < this.numsolids; ++i) {
            int ssize = b.getInt();
            b.position(b.position() + ssize);
        }
        this.physblock = this.readstr(b);
        String[] physdata = this.physblock.split("\n");
        this.gibmodel = new ArrayList();
        for (int i = 0; i < physdata.length; ++i) {
            String line;
            int mindex;
            if (physdata[i].startsWith("break ")) {
                // empty if block
            }
            if ((mindex = (line = physdata[i]).indexOf("\"model\"")) < 0) continue;
            line = line.substring(mindex + 7).trim();
            String[] token = line.split("\"");
            this.gibmodel.add(token[1]);
        }
        this.isValid = true;
    }

    public String readstr(ByteBuffer b) {
        char c;
        StringBuffer linebuff = new StringBuffer();
        while ((c = (char)b.get()) != '\u0000') {
            linebuff.append(c);
        }
        return linebuff.toString();
    }
}

